package com.tykj.workflowcore.model.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.persistence.*;

@Accessors(chain = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class ColumnInfo {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    @JsonIgnore
    private Integer id;

    //-----------------------------//

    @ApiModelProperty(value = "是否是主键 true/false",position = 1)
    private Boolean isPrimary;

    @ApiModelProperty(value = "列名",position = 1)
    private String name;

    @ApiModelProperty(value = "列类型",position = 1)
    private String type;

    @ApiModelProperty(value = "长度",position = 1)
    private Integer length;

    @ApiModelProperty(value = "所属表id",position = 1)
    private Integer tableInfoId;

    @ApiModelProperty(value = "描述",position = 1)
    private String description;

}
