package com.tykj.workflowcore.model.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

@Accessors(chain = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class TableInfoEx {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty("创建时间")
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm")
    @JsonIgnore
    private Date createdTime;

    @ApiModelProperty("修改时间")
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm")
    @JsonIgnore
    private Date updatedTime;

    @ApiModelProperty(value = "聚合对象名", position = 1)
    private String name;

    @ApiModelProperty(value = "描述", position = 2)
    private String description;

    @ApiModelProperty(value = "工作流用预留字段", position = 3)
    private String processKey;

    @ApiModelProperty(value = "版本号", readOnly = true, position = 4)
    private Integer version;

    @ApiModelProperty(value = "绑定信息", position = 5)
    @Transient
    private List<Bind> binds;
}
