/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HibernateConfig;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.PositionSubstringFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupportImpl;
import org.hibernate.dialect.identity.MySQLIdentityColumnSupport;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.sql.BlobTypeDescriptor;
import org.hibernate.type.descriptor.sql.ClobTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class OscarDialect
extends Dialect {
    private static ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        protected String doExtractConstraintName(SQLException sQLException) throws NumberFormatException {
            try {
                int n = Integer.valueOf(JdbcExceptionHelper.extractSqlState((SQLException)sQLException));
                switch (n) {
                    case 23514: {
                        return this.extractUsingTemplate("violates check constraint \"", "\"", sQLException.getMessage());
                    }
                    case 23505: {
                        return this.extractUsingTemplate("violates unique constraint \"", "\"", sQLException.getMessage());
                    }
                    case 23503: {
                        return this.extractUsingTemplate("violates foreign key constraint \"", "\"", sQLException.getMessage());
                    }
                    case 23502: {
                        return this.extractUsingTemplate("null value in column \"", "\" violates not-null constraint", sQLException.getMessage());
                    }
                    case 23001: {
                        return null;
                    }
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    };

    public OscarDialect() {
        this.registerColumnType(-7, "number(1,0)");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "int");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float4");
        this.registerColumnType(8, "float8");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2, "numeric($p, $s)");
        this.registerColumnType(16, "boolean");
        this.registerColumnType(3, "decimal($p, $s)");
        this.registerColumnType(-4, "blob");
        this.registerColumnType(-1, "text");
        this.registerFunction("abs", (SQLFunction)new StandardSQLFunction("abs"));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cot", (SQLFunction)new StandardSQLFunction("cot", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ln", (SQLFunction)new StandardSQLFunction("ln", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sqrt", (SQLFunction)new StandardSQLFunction("sqrt", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cbrt", (SQLFunction)new StandardSQLFunction("cbrt", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction("radians", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction("degrees", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("stddev", (SQLFunction)new StandardSQLFunction("stddev", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("variance", (SQLFunction)new StandardSQLFunction("variance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("rand", (SQLFunction)new NoArgSQLFunction("rand", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("trunc", (SQLFunction)new StandardSQLFunction("trunc"));
        this.registerFunction("ceil", (SQLFunction)new StandardSQLFunction("ceil"));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor"));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction("chr", (Type)StandardBasicTypes.CHARACTER));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction("lower"));
        this.registerFunction("upper", (SQLFunction)new StandardSQLFunction("upper"));
        this.registerFunction("substr", (SQLFunction)new StandardSQLFunction("substr", (Type)StandardBasicTypes.STRING));
        this.registerFunction("initcap", (SQLFunction)new StandardSQLFunction("initcap"));
        this.registerFunction("to_ascii", (SQLFunction)new StandardSQLFunction("to_ascii"));
        this.registerFunction("quote_ident", (SQLFunction)new StandardSQLFunction("quote_ident", (Type)StandardBasicTypes.STRING));
        this.registerFunction("quote_literal", (SQLFunction)new StandardSQLFunction("quote_literal", (Type)StandardBasicTypes.STRING));
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("length", (SQLFunction)new StandardSQLFunction("length", (Type)StandardBasicTypes.LONG));
        this.registerFunction("char_length", (SQLFunction)new StandardSQLFunction("char_length", (Type)StandardBasicTypes.LONG));
        this.registerFunction("bit_length", (SQLFunction)new StandardSQLFunction("bit_length", (Type)StandardBasicTypes.LONG));
        this.registerFunction("octet_length", (SQLFunction)new StandardSQLFunction("octet_length", (Type)StandardBasicTypes.LONG));
        this.registerFunction("current_date", (SQLFunction)new NoArgSQLFunction("current_date", (Type)StandardBasicTypes.DATE, false));
        this.registerFunction("current_time", (SQLFunction)new NoArgSQLFunction("current_time", (Type)StandardBasicTypes.TIME, false));
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgSQLFunction("current_timestamp", (Type)StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("localtime", (SQLFunction)new NoArgSQLFunction("localtime", (Type)StandardBasicTypes.TIME, false));
        this.registerFunction("localtimestamp", (SQLFunction)new NoArgSQLFunction("localtimestamp", (Type)StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("now", (SQLFunction)new NoArgSQLFunction("now", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("timeofday", (SQLFunction)new NoArgSQLFunction("timeofday", (Type)StandardBasicTypes.STRING));
        this.registerFunction("age", (SQLFunction)new StandardSQLFunction("age"));
        this.registerFunction("current_user", (SQLFunction)new NoArgSQLFunction("current_user", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("session_user", (SQLFunction)new NoArgSQLFunction("session_user", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("user", (SQLFunction)new NoArgSQLFunction("user", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("current_database", (SQLFunction)new NoArgSQLFunction("current_database", (Type)StandardBasicTypes.STRING, true));
        this.registerFunction("current_schema", (SQLFunction)new NoArgSQLFunction("current_schema", (Type)StandardBasicTypes.STRING, true));
        this.registerFunction("to_char", (SQLFunction)new StandardSQLFunction("to_char", (Type)StandardBasicTypes.STRING));
        this.registerFunction("to_date", (SQLFunction)new StandardSQLFunction("to_date", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("to_timestamp", (SQLFunction)new StandardSQLFunction("to_timestamp", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("to_number", (SQLFunction)new StandardSQLFunction("to_number", (Type)StandardBasicTypes.BIG_DECIMAL));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)StandardBasicTypes.STRING, "(", "||", ")"));
        this.registerFunction("locate", (SQLFunction)new PositionSubstringFunction());
        this.registerFunction("str", (SQLFunction)new StandardSQLFunction("to_char", (Type)StandardBasicTypes.STRING));
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.jdbc.lob.non_contextual_creation", "true");
    }

    public SqlTypeDescriptor getSqlTypeDescriptorOverride(int n) {
        BlobTypeDescriptor blobTypeDescriptor;
        switch (n) {
            case 2004: {
                blobTypeDescriptor = BlobTypeDescriptor.BLOB_BINDING;
                break;
            }
            case 2005: {
                blobTypeDescriptor = ClobTypeDescriptor.CLOB_BINDING;
                break;
            }
            default: {
                blobTypeDescriptor = super.getSqlTypeDescriptorOverride(n);
            }
        }
        return blobTypeDescriptor;
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getSequenceNextValString(String string) {
        return "select " + this.getSelectSequenceNextValString(string);
    }

    public String getSelectSequenceNextValString(String string) {
        return "nextval('" + string + "')";
    }

    public String getCreateSequenceString(String string) {
        return "create sequence " + string;
    }

    public String getDropSequenceString(String string) {
        return "drop sequence " + string;
    }

    public String getCascadeConstraintsString() {
        return " cascade";
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getQuerySequencesString() {
        return "select * from all_sequences";
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String string, boolean bl) {
        return new StringBuffer(string.length() + 20).append(string).append(bl ? " limit ? offset ?" : " limit ?").toString();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    public String getForUpdateString(String string) {
        return this.getForUpdateString() + " of " + string;
    }

    public Class getNativeIdentifierGeneratorClass() {
        String string = HibernateConfig.configProp.getProperty("NATIVE_TYPE");
        if (string != null && string.toLowerCase().equals("sequence")) {
            return SequenceStyleGenerator.class;
        }
        return super.getNativeIdentifierGeneratorClass();
    }

    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    public String getNoColumnsInsertString() {
        return "default values";
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    public String toBooleanValueString(boolean bl) {
        return bl ? "1" : "0";
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public boolean supportsSubselectAsInPredicateLHS() {
        return false;
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public boolean supportsPooledSequences() {
        return true;
    }

    public ResultSet getResultSet(CallableStatement callableStatement, int n) throws SQLException {
        if (n != 1) {
            throw new UnsupportedOperationException("Oscar only supports REF_CURSOR parameters as the first parameter");
        }
        return (ResultSet)callableStatement.getObject(1);
    }

    public ResultSet getResultSet(CallableStatement callableStatement, String string) throws SQLException {
        throw new UnsupportedOperationException("Oscar only supports accessing REF_CURSOR parameters by name");
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        String string = HibernateConfig.configProp.getProperty("IDENTITY_TYPE");
        if (string != null && string.toLowerCase().equals("auto_increment")) {
            return new MySQLIdentityColumnSupport();
        }
        class OscarIdentityColumnSupport
        extends IdentityColumnSupportImpl {
            OscarIdentityColumnSupport() {
            }

            public boolean supportsIdentityColumns() {
                return true;
            }

            public String getIdentitySelectString(String string, String string2, int n) {
                return "select currval('" + string + '_' + string2 + "_seq')";
            }

            public String getIdentityColumnString(int n) {
                return n == -5 ? "bigserial not null" : "serial not null";
            }

            public boolean hasDataTypeInIdentityColumn() {
                return false;
            }
        }
        return new OscarIdentityColumnSupport();
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorOscarDatabaseImpl.instance;
    }

    static class SequenceInformationExtractorOscarDatabaseImpl
    extends SequenceInformationExtractorLegacyImpl {
        private static final SequenceInformationExtractorOscarDatabaseImpl instance = new SequenceInformationExtractorOscarDatabaseImpl();

        SequenceInformationExtractorOscarDatabaseImpl() {
        }

        protected String sequenceCatalogColumn() {
            return null;
        }

        protected String sequenceSchemaColumn() {
            return null;
        }

        protected String sequenceStartValueColumn() {
            return null;
        }

        protected String sequenceMinValueColumn() {
            return "min_value";
        }

        protected Long resultSetMaxValue(ResultSet resultSet) throws SQLException {
            return resultSet.getBigDecimal("max_value").longValue();
        }

        protected String sequenceIncrementColumn() {
            return "increment_by";
        }
    }
}

