package com.tykj.workflowcore.base.util;

import com.tykj.workflowcore.base.result.ApiException;
import com.tykj.workflowcore.user.util.SpringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;

/**
 * HttpClient调用封装
 *
 * @author HuangXiahao
 * @version V1.0
 * @class AuthenticationUtils
 * @packageName com.example.personnelmanager.common.utils
 **/
@SuppressWarnings("ALL")
@Component
public class HttpClientUtil {

    @Autowired
    CookieStore cookieStore;

    private CloseableHttpClient getClient() {
        return SpringUtils.getBean("client");
    }


    public String post(String url, List<NameValuePair> param, String encode) {
        HttpPost post = new HttpPost(url);
        String result = null;
        CloseableHttpResponse response = null;
        try {
            if (param != null) {
                try {
                    post.setEntity(new UrlEncodedFormEntity(param));
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            response = getClient().execute(post);
            result = ResponseEntityUtil.entityToString(response, encode);
        } catch (IOException e) {
            throw new ApiException("请求接口出现错误");
        } finally {
            try {
                if (post != null) {
                    post.abort();
                    post.releaseConnection();
                }
                if (response != null) {
                    if (response.getEntity() != null) {
                        EntityUtils.consumeQuietly(response.getEntity());
                    }
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }


    public String delete(String url, List<NameValuePair> param, String encode) {
        HttpDeleteWithBody deleteWithBody = new HttpDeleteWithBody(url);
        String result = null;
        CloseableHttpResponse response = null;
        try {
            if (param != null) {
                try {
                    deleteWithBody.setEntity(new UrlEncodedFormEntity(param));
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            response = getClient().execute(deleteWithBody);
            result = ResponseEntityUtil.entityToString(response, encode);
        } catch (IOException e) {
            throw new ApiException("请求接口出现错误");
        } finally {
            try {
                if (deleteWithBody != null) {
                    deleteWithBody.abort();
                    deleteWithBody.releaseConnection();
                }
                if (response != null) {
                    if (response.getEntity() != null) {
                        EntityUtils.consumeQuietly(response.getEntity());
                    }
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String post(String url, String param, String encode) {
        String result = null;
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            if (!StringUtils.isEmpty(param)) {
                StringEntity stringEntity = new StringEntity(param, "utf-8");
                if (post.getHeaders(HttpHeaders.CONTENT_TYPE).length < 1) {
                    post.setHeader(HttpHeaders.CONTENT_TYPE, "application/json");
                }
                post.setEntity(stringEntity);
            }
            response = getClient().execute(post);
            result = ResponseEntityUtil.entityToString(response, encode);
        } catch (IOException e) {
            throw new ApiException("请求接口出现错误");
        } finally {
            try {
                if (post != null) {
                    post.abort();
                    post.releaseConnection();
                }
                if (response != null) {
                    if (response.getEntity() != null) {
                        EntityUtils.consumeQuietly(response.getEntity());
                    }
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String put(String url, String param, String encode) {
        String result = null;
        HttpPut post = new HttpPut(url);
        CloseableHttpResponse response = null;
        try {
            if (!StringUtils.isEmpty(param)) {
                StringEntity stringEntity = new StringEntity(param, "utf-8");
                if (post.getHeaders(HttpHeaders.CONTENT_TYPE).length < 1) {
                    post.setHeader(HttpHeaders.CONTENT_TYPE, "application/json");
                }
                post.setEntity(stringEntity);
            }

            response = getClient().execute(post);
            result = ResponseEntityUtil.entityToString(response, encode);
        } catch (IOException e) {
            throw new ApiException("请求接口出现错误");
        } finally {
            try {
                if (post != null) {
                    post.abort();
                    post.releaseConnection();
                }
                if (response != null) {
                    if (response.getEntity() != null) {
                        EntityUtils.consumeQuietly(response.getEntity());
                    }
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }


    public String get(String url, String encode) {
        HttpGet get = new HttpGet(url);
        String result = null;
        CloseableHttpResponse response = null;
        try {
            response = getClient().execute(get);
            result = ResponseEntityUtil.entityToString(response, encode);
        } catch (IOException e) {
            throw new ApiException("请求接口出现错误");
        } finally {
            try {
                if (get != null) {
                    get.abort();
                    get.releaseConnection();
                }
                if (response != null) {
                    if (response.getEntity() != null) {
                        EntityUtils.consumeQuietly(response.getEntity());
                    }
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }


}
