package com.tykj.workflowcore.base.util;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Locale;

import static java.util.Objects.isNull;

@Component
public class SpringBeanService implements ApplicationContextAware {

    private  ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if(isNull(this.applicationContext)) {
            this.applicationContext = applicationContext;
        }
    }

    /**
     * 获取applicationContext
     */
    public  ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    /**
     * 通过name获取 Bean.
     */
    public  Object getBeanByClassName(String className){
        if (StringUtils.isEmpty(className)){
            return null;
        }
        int lastPoint = className.lastIndexOf(".");
        className = className.substring(lastPoint+1);
        className = className.substring(0,1).toLowerCase(Locale.ROOT)+className.substring(1);
        return getApplicationContext().getBean(className);
    }

    /**
     * 通过name获取 Bean.
     */
    public  Object getBean(String name){
        return getApplicationContext().getBean(name);
    }

    /**
     * 通过class获取Bean.
     */
    public <T> T getBean(Class<T> clazz){
        return getApplicationContext().getBean(clazz);
    }

    /**
     * 通过name,以及Clazz返回指定的Bean
     */
    public <T> T getBean(String name,Class<T> clazz){
        return getApplicationContext().getBean(name, clazz);
    }

}