package com.tykj.workflowcore.model.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.util.List;

@Accessors(chain = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class ColumnInfo {

    @Id
    @ApiModelProperty("主键")
    @JsonIgnore
    private Integer id;

    //-----------------------------//

    @ApiModelProperty(value = "是否是主键 true/false", position = 1)
    private Boolean isPrimary;

    @ApiModelProperty(value = "列名", position = 2)
    private String name;

    @ApiModelProperty(value = "列类型", position = 3)
    private String type;

    @ApiModelProperty(value = "长度", position = 4)
    private Integer length;

    @ApiModelProperty(value = "匹配表达式", position = 5)
    private String pattern;

    @ApiModelProperty(value = "描述", position = 6)
    private String description;

    @ApiModelProperty(value = "引用", position = 7)
    @Transient
    private List<Quote> quotes;

    @JsonIgnore
    private Integer tableInfoId;

}
