package com.tykj.workflowcore.model.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
public class TableInfo {

    @Id
    @ApiModelProperty("主键")
    private Integer id;


    @ApiModelProperty(value = "创建时间", position = 1)
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm")
    private Date createdTime;

    @ApiModelProperty(value = "修改时间", position = 2)
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm")
    private Date updatedTime;

    //------------------------------//

    @ApiModelProperty(value = "基础对象名", position = 3)
    private String name;

    @ApiModelProperty(value = "别名", position = 4)
    private String alias;

    @ApiModelProperty(value = "描述", position = 5)
    private String description;

    @ApiModelProperty(value = "工作流预留字段", position = 6)
    private String processKey;

    @ApiModelProperty(value = "版本号", readOnly = true, position = 7)
    private Integer version;

    @Transient
    @ApiModelProperty(value = "字段信息", position = 8)
    private List<ColumnInfo> columnInfos;

}

