package com.tykj.workflowcore.model.repository;

import com.tykj.workflowcore.model.entity.TableInfo;
import com.tykj.workflowcore.model.entity.TableInfoEx;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;


public interface TableInfoRepository extends JpaRepository<TableInfo, Integer> {

    boolean existsByName(String name);

    Integer countByName(String name);

    TableInfo findByNameAndVersion(String name, Integer version);

    List<TableInfo> findByName(String name);

    void deleteAllByName(String name);

    void deleteAllByNameAndVersion(String name, Integer version);

}
