package com.tykj.workflowcore.user.controller;


import com.alibaba.fastjson.JSONObject;
import com.tykj.workflowcore.user.pojo.LogContent;
import com.tykj.workflowcore.user.pojo.Organization;
import com.tykj.workflowcore.user.pojo.vo.OrganizationVo;
import com.tykj.workflowcore.user.pojo.vo.ServerResponse;
import com.tykj.workflowcore.user.pojo.vo.uservo.FindOrganizationVo;
import com.tykj.workflowcore.user.pojo.vo.uservo.OrganizationLogVo;
import com.tykj.workflowcore.user.service.LogContentService;
import com.tykj.workflowcore.user.service.OrganizationService;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRole;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/organization")
@Api(tags = "组织架构管理")
public class OrganizationController {
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private LogContentService logContentService;

    @ApiOperation("新增组织架构")
    @PostMapping("/addorg")
    public ServerResponse addorg(@Validated @RequestBody OrganizationLogVo organizationLogVo){
        LogContent logContent = new LogContent();
        logContent.setOperator(organizationLogVo.getLoginer());
        logContent.setOperateTime(new Date());
        logContent.setContent("新增组织架构");

        if(organizationLogVo.getOrganization()!=null) {
            Organization organization1 = organizationService.add(organizationLogVo.getOrganization());
            if (organization1 != null) {
                logContent.setResult("操作成功");
                logContentService.save(logContent);
                return ServerResponse.ok(organization1);
            }
        }
        logContent.setResult("操作失败");
        logContentService.save(logContent);
        return ServerResponse.error("新增组织架构失败！");
    }

    @ApiOperation("修改组织架构信息")
    @PostMapping("/update")
    public ServerResponse update(@Validated @RequestBody OrganizationLogVo organizationLogVo){
        LogContent logContent = new LogContent();
        logContent.setOperator(organizationLogVo.getLoginer());
        logContent.setOperateTime(new Date());
        logContent.setContent("修改组织架构信息");

        Organization organization1 = organizationService.update(organizationLogVo.getOrganization());
        if (organization1 != null){
            logContent.setResult("操作成功");
            logContentService.save(logContent);
            return ServerResponse.ok(organization1);
        }

        logContent.setResult("操作失败");
        logContentService.save(logContent);
        return ServerResponse.error("修改组织架构失败！");
    }


    @ApiOperation("根据组织架构id 查看组织架构详情")
    @PostMapping("/findById")
    public ServerResponse findUserById(@Validated @RequestBody FindOrganizationVo findOrganizationVo){

        Organization organization = organizationService.findById(findOrganizationVo.getId());
        if (organization != null){

            return ServerResponse.ok(organization);
        }
        return ServerResponse.error("未查到该组织架构");
    }


    @ApiOperation("查询全部组织架构")
    @GetMapping("/findAll/{name}")
    public ServerResponse findByName(String name){
        List<Organization> organizationList = organizationService.findByOrganizationNameLike(name);
        if (organizationList.size()==0){
            organizationList = organizationService.findAll();
        }
        List<OrganizationVo> organizationVos = organizationService.find(organizationList);
        if (organizationVos != null){
            return ServerResponse.ok(organizationVos);
        }
        return ServerResponse.error("查看组织架构失败");
    }

    @ApiOperation("根据id删除组织架构")
    @DeleteMapping("/delete")
    public ServerResponse delete(@Validated @RequestBody FindOrganizationVo findOrganizationVo) {
        LogContent logContent = new LogContent();
        logContent.setOperator(findOrganizationVo.getLoginer());
        logContent.setOperateTime(new Date());
        logContent.setContent("删除组织架构");
        try{
            organizationService.delete(findOrganizationVo.getId());
            logContent.setResult("操作成功");
            logContentService.save(logContent);
            return ServerResponse.ok("删除成功");
        }catch (Exception e){
            logContent.setResult("操作失败");
            logContentService.save(logContent);
            return ServerResponse.error("删除失败");
        }
    }



}
