package com.tykj.workflowcore.user.dao;


import com.tykj.workflowcore.user.pojo.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository
public interface UserDao extends JpaRepository<User, String >, JpaSpecificationExecutor<User> {

    User findByIdAndDelStatus(String id,Integer delStatus);


    /**
     * 根据用户名查询用户
     * @param username 用户名
     * @return
     */
    User findByUsername(String username);

    /**
     * 根据用户类型查找用户
     * @param type
     * @return
     */
    User findByType(Integer type);


    List<User> findAllByDelStatus(Integer delStatus);


    /**
     * 根据组织架构id 查询用户
     * @param organizationId
     * @return
     */
    List<User> findAllByOrganizationIdAndDelStatus(Integer organizationId,Integer delStatus);

    /**
     * 根据密级 查找用户
     * @param customerLever
     * @param delStatus
     * @return
     */
    List<User> findByCustomerLeverAndDelStatus(String customerLever,Integer delStatus);

    /**
     * 根据删除状态 和用户真实姓名查询用户
     * @param delStatus
     * @param realName
     * @return
     */
    List<User> findByDelStatusAndRealNameLike(Integer delStatus,String realName);




}
