package com.tykj.workflowcore.user.pojo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("权限表")
public class Authority {
    @Id
    @ApiModelProperty(value = "权限id")
    private Integer id;

    @ApiModelProperty(value = "应用名称")
    private String appName;

    @ApiModelProperty(value = "应用的APP_ID，唯一标识" ,example = "0")
    private Integer appId;

    @ApiModelProperty(value = "权限值")
    private String value;

    @ApiModelProperty(value = "权限名称")
    private String name;

    @ApiModelProperty(value = "权限类型 1系统权限  2客户端权限")
    private Integer type;

}
