package com.tykj.workflowcore.user.pojo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("存储私密钥")
@Table
public class StorageKey {

    @Id
    @ApiModelProperty(value = "权限id")
    private Integer id;

    @Lob
    @ApiModelProperty(value = "应用签名公钥，由系统生成。公钥发放给应用的负责人，用于对JWT验签")
    private String signPublicKey
            = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApAISjKVxv1SSFmORcTebj+y0aiuItJeDhyA8Vz4KUirMLb/+qR5khlGnv2bd8SCrHSZdGrAXZBj1F3pCWNPoKPOp3+e2IudEhzGq4fPgwbkD1EjmHoSsENXpzuk/OUMAIZKb2c0t+mlIrc8El6g18crWvPlv43h+wryyHxy9gMs2+Oj+MBSrPgeiX/Sj12mlBdX6bhSMWGllnRyo6ABA9D/RzypvfiMM8a8SmKzkNqYU4K4JFjAaH0pa44dMdupCExi3Feq3Q0Bg0APe4EqRy8Et4lf58hG0Khy8R0arLh69VAkFgXlrMMtW3tLTBQZVIMIPBgqt+ajeVGc2ue+DYQIDAQAB";

    @Lob
    @ApiModelProperty(value = "应用签名私钥，由系统生成。私钥用于对JWT进行签名")
    private String signPrivateKey
            = "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCkAhKMpXG/VJIWY5FxN5uP7LRqK4i0l4OHIDxXPgpSKswtv/6pHmSGUae/Zt3xIKsdJl0asBdkGPUXekJY0+go86nf57Yi50SHMarh8+DBuQPUSOYehKwQ1enO6T85QwAhkpvZzS36aUitzwSXqDXxyta8+W/jeH7CvLIfHL2Ayzb46P4wFKs+B6Jf9KPXaaUF1fpuFIxYaWWdHKjoAED0P9HPKm9+IwzxrxKYrOQ2phTgrgkWMBofSlrjh0x26kITGLcV6rdDQGDQA97gSpHLwS3iV/nyEbQqHLxHRqsuHr1UCQWBeWswy1be0tMFBlUgwg8GCq35qN5UZza574NhAgMBAAECggEBAJ8yv8y0P5CIR/Hhnmk2oBL5ojq4nU8nD24X1VqeByixEFaMWmbQ8KUNF/aLpH4NxutZtOBV866fJzEt5L8SmvU9aDTGV57TvEo65PPFZfLFY7kpNe6Du/3vlq/Y6xzrM3JjPFMTfkDm97x3Ca8ogYx95ymyOnCkIu9meMQIgs5DYsmGzTrl1YYVryJ0BeVFRBQkbfZRQ46rraYZL1flcYJBG8GcRo+kZNwKA9IHLt7khYvFpxjEF6Ppem3X3X/3CIC32q6wjeY50u8w87XGR8XVVRIqIorBpXtODjvYYqeBsofYYSZ/hh/+WFgoCoGSk+nDcaGO/hnGQ61jscUSaz0CgYEA6K/uJNb8WYYbuaJyoYb53LHcp334uLvLXW5QoZ3J/g+t/D0nvz7Pk3W81dv6NpQBCGT7qN5e0ip+an1fj5/LbljgOhW6DpYF5Ggo5Lf5AXkD8iDgTspd76AUFyaRYLJtS0+SPtPLv1tQ3ek7uXdDfopL9yjM1WnWfZe2MUtQtX8CgYEAtHCgxrFo9nAKT6ehsbpvAzNW7j/NnuMKPdvMYX4AFv1twdc+K2qor2UNkwMNnRuL5ESh+1RXH+Y1WhC+hwJYqDXsYob99qy9FkNfU2MqJgHXEbiLglR2dT0ELQ3Iql5QpJVdLqDUljrYqGDrGC3U6LQO05C7F74ouTb3LsH09x8CgYBgNe5H+USaV6M7HHo9Y6wIntpXvvSKncu2tBhO2wlcLWuJMlgu8W+uzy3nV2+cBZJvwCF2b4vRZpSiv3g10KKy27jLC5TE1y9Ug+T0vUUOYNVK1mEo8u/oVs43zFCsJNqgGySjKbvDQaSsPPXe9/tGZTSH26zmST7Q61wAAd47TQKBgDPmGThNGuWXAEA89PMLrpZ7E8vfKiNDJlT4fWalOR1js0gHwuf1+6LHLApW3HmNzMTRQM3rSkvwiPPo0QRAFoP7ToxgS3fB43kd07NGWH8qFFQSgn3wEUpTTHow9sCZ9BQCqhSZScwUDPERP01rEUwFTiZoAIgpt8jeGGaofu79AoGASFnAKGxDY41J6Wq9+BQBW0nk34TZo7Fz+cKIpQ5/zw2iVbUF3x1hCBn5CMn3mJHBCS4L7A/mTYN34VvfUDWbqxoRJAz5qNNuA5Ljko2cdZjNjZGFovfqnvo7I1zdoM5DnO1SMEgP+nxy4hzpmo990jkQcbAHaIesgT93Sl2MZo4=";

    @Lob
    @ApiModelProperty(value = "应用jwt加密公钥，由系统生成。用于对JWT加密")
    private String rsaPublicKey
            = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjVT15mHtFXaYc7xsTtkXJPxVlN5JhRBdP0XwNQ5m9sJdgTLyz1mesBPc3r0K7ZPphdszlSBb3OdCKFafUILS8jiBDo4DHZ2CNpyqBODgJIE46PN+DfcJWfHA4BZHiqQNL1q6SJufr2fmKm57uZGdNhdNstzWtXkt3NPyaEr4HaI8hPbntIVybJD5F6HeTuXf0inikdMwzj/sAQguJmmv23be/NrUELH4JwEm9Kse+yFzXtSi61s71XJMvizSlcRW2m9IzhVRBjVFt509b+ptTjxgrNL4QuAA8WY/B/mJZZ0mAFcAwkLCILwlfhQmPBO3Tw7mj9QeTebml2vt/fjjIwIDAQAB";

    @Lob
    @ApiModelProperty(value = "应用jwt解密私钥，由系统生成。私钥发放给应用的负责人，用于对JWT解密")
    private String rsaPrivateKey
            = "MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCNVPXmYe0VdphzvGxO2Rck/FWU3kmFEF0/RfA1Dmb2wl2BMvLPWZ6wE9zevQrtk+mF2zOVIFvc50IoVp9QgtLyOIEOjgMdnYI2nKoE4OAkgTjo834N9wlZ8cDgFkeKpA0vWrpIm5+vZ+Yqbnu5kZ02F02y3Na1eS3c0/JoSvgdojyE9ue0hXJskPkXod5O5d/SKeKR0zDOP+wBCC4maa/bdt782tQQsfgnASb0qx77IXNe1KLrWzvVcky+LNKVxFbab0jOFVEGNUW3nT1v6m1OPGCs0vhC4ADxZj8H+YllnSYAVwDCQsIgvCV+FCY8E7dPDuaP1B5N5uaXa+39+OMjAgMBAAECggEAVYKmFPIC5A2RR9UlIr+uhS43CY9EpEG2aWYDY9aG7Z3DvTv6NQJgROB/rjRqvDvV+qsZloyxiAJTwNxIIApHX05Yp1m9ANofwrMfGzyD4RJeQHOyPPjOq6DdtbdFKdkAMTqPowaloxcV525ZZXl4yRVoaWO8dKgQ259Q91EEtchf+v3FSlrAuH9K6RLRnpNqO9ryNlIES6nipKjqUu2p2f65f94s8eQtAt/JDGq16+xs8lDxRLahpFJSYdMFBS5wzLQGAJ7MiVD6VDNBkFM8dDEdaqRuVO3xBcRLx4EM0FFN5TmzC7d8hfNX771vM7iEZlcT6xfTWIeFdfD0Yhz5QQKBgQDQaSrNlnLZlSgS90TGmsgRfpmCsX5J6nRFZ4an+Zg3EnRsTVSkSHxLWGmml4Jxa92OL2gaMOdhUuPtd34B8brgFwoae0sAHBGfMoK1khWJV9t4Uh4uLRivH7nBm4+mwj0QKq5VW0ABrS+gPf4+XyPT0/86Ilm7863++/Uh8A1bSQKBgQCtmqMDXXjRK36sRtto1fCowZhkhD1IAW2btgTtN26pXRWjlLHGAPcOqa7mKdjJgsA8RjBqvDWTNv5N/5q0fZZm9s6N0aLL/ofuEo+bwRVlPpL/QysCKuAmfLO8l4kUV4O8IRHMz3SIooz5Ia5bCJvAQ2L4KEugM0KaGRXjTXc/CwKBgEYizkPHmLj+iDDxw9RubFvu1ex0nQJ1A1IEB/3pcj8+V63GzHBI8INOqqdkn4JaAYKDE66UvJk1Ev1sVByFZBVby4uj6FaOG6QOlIxUMCk7RuGUCRITHRZ6P8IW/t3oyjHxmx+giMbHqJptom0NCXqVAnRm8PnehLSlyBX2uhf5AoGAQvMRzqhrgW8eqN2im+l1p/8RACKnZ291j8lAWSM5gAMv5yfe7xdML9Fsa8LTodLUw+nlniP7HUzmAbqDNPwB1q9ztOmVuMnuLffmfhCWabcaBWsn2OwkCXOp9R8TdE7TtOej77JJpK/bYfCFRwIo3pqePkl78MoT802dTU2AoUUCgYAj0YsmkhgwPCgW15uFVpS8AFyBmbBopM9JuBf7hLYKTeMNgYghiL+ziYPrX9pFvcCV4OGkUnUf+HicF0KmL4Hj+w5kfmsx7+vtInKSoQnBEC2mbitxzGBtsIFVGYdaBqo6bfTYoWs4sy0TU8cfkJQKqVgodLJFkU1hMoQYDuQVgw==";

}
