package com.tykj.workflowcore.user.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.programmaticallyspeaking.aptdemo.NoAutoIncreament;
import com.tykj.workflowcore.user.pojo.vo.OrganizationVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedDate;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("用户")
@Table
public class User {

    @Id
    @ApiModelProperty(value = "用户编号",example = "1")
    @NoAutoIncreament
    private String id;

    @ApiModelProperty(value = "用户姓名")
    private String realName;

    @ApiModelProperty(value = "用户名")
    private String username;

    @ApiModelProperty(value = "经过加密的密码")
    private String password="qwer1234" ;

    @ApiModelProperty(value = "联系方式")
    private String phone;

    @ApiModelProperty(value = "锁定状态（0为未锁，1为锁死）")
    private Integer locked = 0;

    @ApiModelProperty(value = "用户的性别")
    private String sex ;

    @ApiModelProperty(value = "身份证号")
    private String idCardNumber;

    @ApiModelProperty(value = "头像或证件照")
    private String picturePath;

    @ApiModelProperty(value = "删除状态:1.未删除；2.删除")
    private Integer delStatus= 1;

    @ApiModelProperty(value = "如果用户姓名在数据库内重复，当第二个重复的用户姓名，注册进系统时，该数字加1。例如：张三张三2张三3")
    private Integer repeatsNum = 0;

    @CreatedDate
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(value = "机构编码")
    private String organizationCode;

    @ApiModelProperty(value = "机构id")
    private Integer organizationId;

    @ApiModelProperty(value = "机构名称")
    private String organizationName;

    @ApiModelProperty(value = "用户类型")
    private String customerType;

    @ApiModelProperty(value = "用户岗位")
    private String organizationPost;

    @ApiModelProperty(value = "用户职务")
    private String customerTitle;

    @ApiModelProperty(value = "用户密级")
    private String customerLever;

    @ApiModelProperty(value = "用户类型 0普通用户 1管理员 2安全员 3审计员")
    private Integer type = 0;

    @Transient
    private List<Organization> organizationList;

    @Transient
    private List<String> groupStrings;



}
