package com.tykj.workflowcore.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.github.wenhao.jpa.Specifications;
import com.tykj.workflowcore.user.dao.AuthorityDao;
import com.tykj.workflowcore.user.dao.UserAuthorityDao;
import com.tykj.workflowcore.user.dao.UserDao;
import com.tykj.workflowcore.user.pojo.Authority;
import com.tykj.workflowcore.user.pojo.User;
import com.tykj.workflowcore.user.pojo.UserAuthority;
import com.tykj.workflowcore.user.pojo.vo.PageResponse;
import com.tykj.workflowcore.user.service.UserAuthorityService;
import com.tykj.workflowcore.user.service.CenterUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class UserAuthorityServiceImpl implements UserAuthorityService {
    @Autowired
    private UserAuthorityDao userAuthorityDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private AuthorityDao authorityDao;
    @Autowired
    private CenterUserService centerUserService;

    @Override
    public List<UserAuthority> findByUid(String uid) {
        List<UserAuthority> userAuthorityList = userAuthorityDao.findByUid(uid);
        if (userAuthorityList != null){
            return userAuthorityList;
        }
        return null;
    }

    @Override
    public List<Integer> findAuthByUid(String uid) {
        ArrayList<Integer> authIds = new ArrayList<>();
        List<UserAuthority> authorityList = findByUid(uid);
        if (authorityList!=null){
            for (UserAuthority userAuthority : authorityList) {
                authIds.add(userAuthority.getAuthorityId());
            }
            return authIds;
        }
        return null;
    }

    @Override
    public UserAuthority findByUidAndAuthorityId(String uid, Integer authorityId) {
        UserAuthority userAuthority = userAuthorityDao.findByUidAndAuthorityId(uid, authorityId);
        if (userAuthority!= null){
            return userAuthority;
        }
        return null;
    }

    @Override
    public void delete(UserAuthority userAuthority) {
        userAuthorityDao.delete(userAuthority);
    }

    @Override
    public UserAuthority save(UserAuthority userAuthority) {
        UserAuthority userAuthority1 = userAuthorityDao.save(userAuthority);
        if (userAuthority1!=null){
            return userAuthority1;
        }
        return null;
    }

    @Override
    public PageResponse<User> findByAuthId(Integer authId, int page, int size) {
        List<UserAuthority> userAuthorityList = userAuthorityDao.findByAuthorityId(authId);
        List<String> userIds = new ArrayList<>();
        if (userAuthorityList!=null){
            for (UserAuthority userAuthority : userAuthorityList) {
                userIds.add(userAuthority.getUid());
            }
        }
        Specification<User> specification = Specifications.<User>and()
                .in(userIds!=null,"id",userIds)
                .eq("delStatus",1)
                .build();
        if (page <= 0) {
            page = 1;
        }
        Pageable pageable = PageRequest.of(page - 1, size);
        List<User> userList = userDao.findAll(specification, pageable).getContent();
        long count = userDao.count(specification);
        return new PageResponse<>(page, size, count, userList);
    }


    @Override
    public void delete(Integer authId, String uId) {
        UserAuthority userAuthority = userAuthorityDao.findByUidAndAuthorityId(uId, authId);
        userAuthorityDao.delete(userAuthority);
    }

    @Override
    public List<User> findByAuthId(Integer authId) {
        List<User> userList = new ArrayList<>();
        List<UserAuthority> userAuthorityList = userAuthorityDao.findByAuthorityId(authId);
        for (UserAuthority userAuthority : userAuthorityList) {
            User user = userDao.findByIdAndDelStatus(userAuthority.getUid(), 1);
            userList.add(user);
        }
        return userList;
    }

    @Override
    public String findAppByUserId(String uid) {
        System.out.println("////:"+uid);
        List<Integer> appIds = new ArrayList<>();
        List<UserAuthority> userAuthorityList = userAuthorityDao.findByUid(uid);
        System.out.println(userAuthorityList.size());
        if (userAuthorityList != null){
            for (UserAuthority userAuthority : userAuthorityList) {
                System.out.println("userAuthority:"+userAuthority.toString());
                if (userAuthority != null){
                    Authority authority = authorityDao.findById(userAuthority.getAuthorityId()).get();
                    appIds.add(authority.getAppId());
                }
            }
        }
        String jsonString = JSON.toJSONString(appIds);
        return jsonString;
    }
}
