package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.workflow_editer.entity.ActivityNodeInfo;
import com.tykj.workflowcore.workflow_editer.entity.vo.ActivityNodeInfoSelectVo;
import com.tykj.workflowcore.workflow_editer.service.ActivityNodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags = "流程节点信息管理")
@RequestMapping("/activeInfo")
public class ActivityNodeController {

    @Autowired
    ActivityNodeService activityNodeService;

    @PostMapping("/save")
    @ApiOperation(value = "保存节点信息")
    public ResponseEntity getAllUsers(@RequestBody ActivityNodeInfo activityNodeInfo){
        ActivityNodeInfo save;
        if (activityNodeInfo.getId()!=null){
            save = activityNodeService.update(activityNodeInfo);
        }else {
            save = activityNodeService.save(activityNodeInfo);
        }
        return ResultUtil.success(save,"保存成功");
    }

    @PostMapping("/select")
    @ApiOperation(value = "获取节点信息")
    public ResponseEntity select(@RequestBody ActivityNodeInfoSelectVo activityNodeInfo){
        Page<ActivityNodeInfo> all = activityNodeService.findAll(activityNodeInfo);
        return ResultUtil.success(all,"查询成功");
    }

}
