package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.workflow_editer.entity.DataHistory;
import com.tykj.workflowcore.workflow_editer.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * ClassName:    FlowsInfoController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/2/24   10:13
 * @Author: zsp
 */
@RestController
@Api(tags = "历史数据接口")
@RequestMapping("/dataHistory")
@Slf4j
public class DataHistoryController {

    @Autowired
    private DataHistoryService dataHistoryService;

    @PostMapping("/saveDataHistory")
    @ApiOperation(value = "保存历史数据")
    public void saveDataHistory(@RequestBody DataHistory dataHistory){
        dataHistoryService.save(dataHistory);
    }


}
