package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.user.pojo.UserDetail;
import com.tykj.workflowcore.user.util.AuthenticationUtils;
import com.tykj.workflowcore.workflow_editer.entity.DataHistory;
import com.tykj.workflowcore.workflow_editer.entity.vo.*;
import com.tykj.workflowcore.workflow_editer.service.DataHistoryService;
import com.tykj.workflowcore.workflow_editer.service.WorkFlowService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ClassName:    WorkFlowController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/3/2   9:48
 *
 * @Author: zsp
 */
@Api(tags = "工作流管理接口")
@RestController
@RequestMapping("/workFlow")
public class WorkFlowController {

    @Autowired
    private WorkFlowService workFlowService;

    @Autowired
    AuthenticationUtils authenticationUtils;

    @Autowired
    DataHistoryService dataHistoryService;



    @PostMapping("/startFlow")
    @ApiOperation("开启流程")
    public ResponseEntity startFlow(@RequestBody StartFlowVo startFlowVo){
        workFlowService.startFlow(startFlowVo);
        return ResultUtil.success("流程开启成功");
    }

    @GetMapping("/deployFlow")
    @ApiOperation("部署流程")
    public ResponseEntity deployFlow(Integer id) throws FileNotFoundException {
        workFlowService.deployXml(id);
        return ResultUtil.success("流程部署成功");
    }

    @PostMapping("/findUserTask")
    @ApiOperation("任务个人待办列表")
    public List<Map<String,Object>> findUserTask(@RequestBody NextTaskVo nextTaskVo){
        UserDetail authentication = authenticationUtils.getAuthentication();
        nextTaskVo.setGroupStrings(authentication.getGroupStrings());
        nextTaskVo.setUserId(authentication.getId());
        return workFlowService.findTaskByUserId(nextTaskVo);
    }

    @GetMapping("/findTaskDetail")
    @ApiOperation("任务个人待办任务详情")
    public Map<String, Object> findTaskDetail(String taskId){
        return  workFlowService.findTaskDetail(taskId);
    }

    @PostMapping("/completeTask")
    @ApiOperation("完成任务")
    public ResponseEntity completeTask(@RequestBody TaskVo taskVo){
        workFlowService.completeTask(taskVo);
        return ResultUtil.success("任务已完成");
    }

    @PostMapping("/isTransferTask")
    @ApiOperation("是否转交任务")
    public ResponseEntity isTransferTask(@RequestBody TransferTask transferTask){
        workFlowService.transferTask(transferTask);
        return ResultUtil.success("该任务转交成功");
    }

    @GetMapping("/isSuspension")
    @ApiOperation("是否挂起")
    public ResponseEntity isSuspension(Integer id){
        workFlowService.suspendOrActivateProcessDefinitionByKey(id);
        return ResultUtil.success("该流程已经成功"+(id==0?"启用":"禁用"));
    }

    @DeleteMapping("/deleteFlow")
    @ApiOperation("是否删除")
    public ResponseEntity deleteFlow(Integer id){
        workFlowService.deleteFlow(id);
        return ResultUtil.success("该流程删除成功");
    }

    @PostMapping("/flowProgress")
    @ApiOperation("流程进度")
    public void flowProgress(@RequestBody FlowProcessVo flowProcessVo) throws IOException {
        workFlowService.flowProgress(flowProcessVo.getResponse(),flowProcessVo.getProcessInstanceId());
    }

    @PostMapping("/findHistoryTask")
    @ApiOperation("已办任务")
    public ResponseEntity findHistoryTask(@RequestBody MyTaskSelectVo myTaskSelectVo) {
        UserDetail authentication = authenticationUtils.getAuthentication();
        myTaskSelectVo.setUserId(authentication.getId());
        return ResultUtil.success(workFlowService.findHistoryTask(myTaskSelectVo),"");
    }

    @PostMapping("/findStartByUser")
    @ApiOperation("查询我发起的流程")
    public ResponseEntity findStartByUser(@RequestBody MyStartProcessSelectVo myStartProcessSelectVo) {
        //入参 分页 状态 流程标题
        UserDetail authentication = authenticationUtils.getAuthentication();
        myStartProcessSelectVo.setUserId(authentication.getId());
        PageReturnVo<List<ProcessInstanceReturnVo>> pageReturnVo = workFlowService.findStartByUser(myStartProcessSelectVo);
        return ResultUtil.success(pageReturnVo,"查询成功");
    }

    @GetMapping("/stopProcessInstance")
    @ApiOperation("中止流程")
    public ResponseEntity stopProcessInstance(String processInstanceId) {
        workFlowService.stopProcessInstanceById(processInstanceId);
        return ResultUtil.success("停止成功");
    }

    @GetMapping("/getProcessInstanceLastInfo")
    @ApiOperation("查询流程的最后一个节点")
    public ResponseEntity getProcessInstanceLastInfo(String processInstanceId) {
        HistoricActivityInstance lastActivityByProcessInstance = workFlowService.findLastActivityByProcessInstance(processInstanceId);
        String uniqueString = DataHistory.initUniqueString(lastActivityByProcessInstance.getExecutionId(),lastActivityByProcessInstance.getProcessInstanceId(),lastActivityByProcessInstance.getActivityId());
        DataHistory byUniqueString = dataHistoryService.findByUniqueString(uniqueString);
        return ResultUtil.success(byUniqueString,"查询成功");
    }

    @GetMapping("/getActivityHistoryInfo")
    @ApiOperation("根据ID查询我执行的任务详情")
    public ResponseEntity getActivityHistoryInfo(String id) {
        HistoricActivityInstance activityById = workFlowService.findActivityById(id);
        String uniqueString = DataHistory.initUniqueString(activityById.getExecutionId(),activityById.getProcessInstanceId(),activityById.getActivityId());
        DataHistory byUniqueString = dataHistoryService.findByUniqueString(uniqueString);
        return ResultUtil.success(byUniqueString,"查询成功");
    }

}
