package com.tykj.workflowcore.workflow_editer.dao;

import com.tykj.workflowcore.workflow_editer.entity.FormPage;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * ClassName:    PageEntityMapper
 * Package:    com.tykj.mapper
 * Description:
 * Datetime:    2021/3/3   13:12
 *
 * @Author: zsp
 */
public interface FormPageMapper extends JpaRepository<FormPage,Integer> , JpaSpecificationExecutor<FormPage> {

    //根据PROCESS 查询最新版本的页面
    @Query(value = "SELECT f1.* FROM FORMPAGE as f1 RIGHT JOIN (SELECT PAGEIDENTIFICATION,MAX(VERSION) as VERSION  FROM FORMPAGE GROUP BY PAGEIDENTIFICATION ) as f2 on f2.PAGEIDENTIFICATION = f1.PAGEIDENTIFICATION and f2.VERSION = f1.VERSION WHERE PROCESSKEY = ?1",nativeQuery = true)
    List<FormPage> findNewFromPageByProcessKey(String processKey);
}
