package com.tykj.workflowcore.workflow_editer.entity;

import com.tykj.workflowcore.base.entity.BaseEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Lob;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@SQLDelete(sql = "update ACTIVITYNODEINFO set deleted = 1 where id = ?")
@Where(clause = "deleted = 0")
@Api("节点信息")
public class ActivityNodeInfo extends BaseEntity {

    @ApiModelProperty("流程Key")
    private String processKey;

    @Lob
    @ApiModelProperty("数据")
    private String data;


}
