package com.tykj.workflowcore.workflow_editer.entity;

import com.tykj.workflowcore.base.entity.BaseEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Lob;

/**
 * ClassName:    DataHistory
 * Package:    com.tykj.workflowcore.workflow_editer.entity
 * Description:
 * Datetime:    2021/4/16   15:21
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@SQLDelete(sql = "update DATAHISTORY set deleted = 1 where id = ?")
@Where(clause = "deleted = 0")
@Api("历史数据")
public class DataHistory extends BaseEntity {

    @ApiModelProperty("执行实例ID")
    private String executionId;

    @ApiModelProperty("流程实例id")
    private String processInstanceId;

    @ApiModelProperty("节点Id")
    private String activityId;

    @ApiModelProperty("执行实例ID_流程实例id_节点Id  用于作为索引")
    private String uniqueString;

    @ApiModelProperty("页面id")
    private String pageId;

    @ApiModelProperty("页面名称")
    private String pageName;

    @ApiModelProperty("页面描述")
    private String pageDesc;

    @ApiModelProperty("模板")
    @Lob
    private String template;

    @ApiModelProperty("页面js")
    @Lob
    private String js;

    @ApiModelProperty("页面css")
    @Lob
    private String css;

    @ApiModelProperty("json描述文件")
    @Lob
    private String descFile;

    @ApiModelProperty("变量数据")
    @Lob
    private String datas;

    @ApiModelProperty("页面操作用户id")
    private Integer userId;

    @ApiModelProperty("索引Key")
    @Lob
    private String IndexKey;

    public static String initUniqueString(String executionId,String processInstanceId,String activityId){
        return executionId+"_"+processInstanceId+"_"+activityId ;
    }

}
