package com.tykj.workflowcore.workflow_editer.entity;

import com.alibaba.fastjson.JSONObject;
import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.workflow_editer.entity.vo.CandidateRoleDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Lob;
import java.util.List;

/**
 * ClassName:    FlowsInfo
 * Package:    com.tykj.entity
 * Description:
 * Datetime:    2021/2/23   10:12
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@SQLDelete(sql = "update FLOWSINFO set deleted = 1 where id = ?")
@Where(clause = "deleted = 0")
@Api("流程表")
public class FlowsInfo extends BaseEntity {


    @ApiModelProperty("发起人的Id")
    private Integer userId;

    @ApiModelProperty("发起人的名字")
    private String userName;

    @ApiModelProperty("流程名称")
    private String flowName;

    @ApiModelProperty("资源名称")
    private String resourceName;

    @ApiModelProperty("流程主键")
    private String flowKey;

    @ApiModelProperty(value = "部署状态",notes = "0 已启用，1 未启用")
    private Integer state;

    @ApiModelProperty("文件路径")
    private String filePath;

    @ApiModelProperty("自定义格式XML路径")
    private String fileCustomPath;

    @ApiModelProperty("流程描述")
    private String flowDescribe;

    @ApiModelProperty("页面ID，示例 1,2,3,4")
    private String pageIds;

    @ApiModelProperty("开始节点页面的id")
    private Integer startPageId;

    @ApiModelProperty("流程实例id")
    private String processInstanceId;

    @ApiModelProperty("是否和之前一样  0是一样  1不一样")
    private Integer isOld;
    /**
    * @Description:
    * @params: 部署id
    */
    private String deployId;

    @ApiModelProperty("流程所拥有的模型")
    private String tableInfoIds;

    @ApiModelProperty("是否所有用户都可以发起")
    private Integer allUser = 0;

    @ApiModelProperty("流程可发起用户 示例1,2,3,4,5,   最后一个 , 结尾一定要加上")
    @Lob
    private String candidateUser;

    @ApiModelProperty("流程可发起用户组  示例role_1,department_2,   最后一个 , 结尾一定要加上")
    @Lob
    private String CandidateGroup;

    @ApiModelProperty("流程可发起用户前端回显的Json字段  前端传过来的")

    @Lob
    private String CandidateJson;

}
