package com.tykj.workflowcore.workflow_editer.entity.vo;

import com.tykj.workflowcore.workflow_editer.entity.FormPage;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

import javax.persistence.Lob;
import java.util.Date;
import java.util.List;

/**
 * ClassName:    FormPageVo
 * Package:    com.tykj.vo
 * Description:
 * Datetime:    2021/3/3   13:32
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class FormPageVo {

    @ApiModelProperty("页面id")
    private Integer id;

    @ApiModelProperty("页面名称")
    private String pageName;

    @ApiModelProperty("页面描述")
    private String pageDesc;

    @ApiModelProperty("模板")
    @Lob
    private String template;

    @ApiModelProperty("页面js")
    @Lob
    private String js;

    @ApiModelProperty("页面css")
    @Lob
    private String css;

    @ApiModelProperty("创建的时间")
    private Date createTime;

    @ApiModelProperty("修改的时间")
    private Date updateTime;

    @ApiModelProperty("json描述文件")
    @Lob
    private String descFile;

    @ApiModelProperty("所属流程key")
    private String processKey;

    @ApiModelProperty("实体类")
    private List<String> entityIds;

    public FormPage toEntity(){
        FormPage formPage = new FormPage();
        StringBuffer idStr = new StringBuffer();
        for (int i = 0; i < entityIds.size(); i++) {
            idStr.append(entityIds.get(i));
            idStr.append(",");
            if (i == entityIds.size()-1){
                idStr.deleteCharAt(idStr.length()-1);
            }
        }
        formPage.setEntityId(idStr.toString());
        BeanUtils.copyProperties(this,formPage);
        return formPage;
    }


}
