package com.tykj.workflowcore.workflow_editer.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.workflowcore.base.result.ApiException;
import com.tykj.workflowcore.workflow_editer.dao.ActivityNodeInfoMapper;
import com.tykj.workflowcore.workflow_editer.entity.ActivityNodeInfo;
import com.tykj.workflowcore.workflow_editer.entity.vo.ActivityNodeInfoSelectVo;
import com.tykj.workflowcore.workflow_editer.service.ActivityNodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Optional;

@Service
public class ActivityNodeServiceImpl implements ActivityNodeService {

    @Autowired
    ActivityNodeInfoMapper activityNodeInfoMapper;

    @Override
    public ActivityNodeInfo save(ActivityNodeInfo activityNodeInfo) {
        return activityNodeInfoMapper.save(activityNodeInfo);
    }

    @Override
    public ActivityNodeInfo update(ActivityNodeInfo activityNodeInfo) {
        return activityNodeInfoMapper.save(activityNodeInfo);
    }

    @Override
    public ActivityNodeInfo findOneById(Integer id) {
        Optional<ActivityNodeInfo> byId = activityNodeInfoMapper.findById(id);
        if (!byId.isPresent()){
            throw new ApiException("找不到数据");
        }
        return byId.get();

    }

    @Override
    public Page<ActivityNodeInfo> findAll(ActivityNodeInfoSelectVo activityNodeInfoSelectVo) {
        PredicateBuilder<ActivityNodeInfo> predicateBuilder = Specifications.and();
        predicateBuilder.eq(!StringUtils.isEmpty(activityNodeInfoSelectVo.getProcessKey()),"processKey", activityNodeInfoSelectVo.getProcessKey());
        Page<ActivityNodeInfo> all = activityNodeInfoMapper.findAll(predicateBuilder.build(), activityNodeInfoSelectVo.getPageable());
        return all;
    }

    @Override
    public void delete(Integer id) {
        try {
            activityNodeInfoMapper.deleteById(id);
        }catch (Exception e){
            e.printStackTrace();
            throw new ApiException("删除失败,请联系管理员");
        }

    }
}
