package com.tykj.workflowcore.workflow_editer.service.impl;

import com.tykj.workflowcore.user.controller.OrganizationController;
import com.tykj.workflowcore.user.pojo.User;
import com.tykj.workflowcore.user.pojo.UserDetail;
import com.tykj.workflowcore.user.pojo.vo.OrganizationVo;
import com.tykj.workflowcore.user.service.CenterUserService;
import com.tykj.workflowcore.user.util.AuthenticationUtils;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRole;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRoleType;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowUser;
import com.tykj.workflowcore.workflow_editer.entity.enums.RoleTypeEnum;
import com.tykj.workflowcore.workflow_editer.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class DefaultUserSerbiveImpl
 * @packageName com.tykj.workflowcore.workflow_editer.service.impl
 **/
@Service
@Order
public class DefaultUserServiceImpl implements UserService {

    @Autowired
    OrganizationController organizationController;

    @Autowired
    AuthenticationUtils authenticationUtils;

    @Autowired
    CenterUserService centerUserService;
    @Override
    public WorkFlowUser getCurrentUser() {
        UserDetail authentication = authenticationUtils.getAuthentication();
        WorkFlowUser workFlowUser = new WorkFlowUser();
        workFlowUser.setId(authentication.getId());
        workFlowUser.setName(authentication.getRealName());
        return workFlowUser;
    }

    @Override
    public List<WorkFlowUser> getAllUser() {
        List<User> all = centerUserService.findAll();
        List<WorkFlowUser> collect = all.stream().map(
                user -> new WorkFlowUser(user.getId(), user.getRealName())
        ).collect(Collectors.toList());

        return collect;
    }

    @Override
    public List<WorkFlowRole> getAllRole(String roleType) {
        List<WorkFlowRole> workFlowUsers = new ArrayList<>();
        if (roleType.equals(RoleTypeEnum.ORGANIZATION.name())){
            List<OrganizationVo> data = (List<OrganizationVo>) organizationController.findByName(null).getData();
            List<WorkFlowRole> workFlowRoles = changeOrgToWorkFlowRole(data);
            workFlowUsers.addAll(workFlowRoles);
        } else if (roleType.equals(RoleTypeEnum.ROLE.name())){
            workFlowUsers.add(new WorkFlowRole("管理员","role","1",null));
            workFlowUsers.add(new WorkFlowRole("普通用户","role","2",null));
            workFlowUsers.add(new WorkFlowRole("运维人员","role","3",null));
        }

        return workFlowUsers;
    }

    @Override
    public List<WorkFlowRoleType> getRoleType() {
        List<WorkFlowRoleType> workFlowRoleTypes = new ArrayList<>();
        workFlowRoleTypes.add(new WorkFlowRoleType("用户","user","user",new ArrayList<>()));
        workFlowRoleTypes.add(new WorkFlowRoleType("组织架构",RoleTypeEnum.ORGANIZATION.name(),"group",new ArrayList<>()));
        workFlowRoleTypes.add(new WorkFlowRoleType("角色",RoleTypeEnum.ROLE.name(),"group",new ArrayList<>()));
        return workFlowRoleTypes;
    }

    public List<String> getUserGroupList(){
        UserDetail userDetail = authenticationUtils.getAuthentication();

        return null;
    }

    private List<WorkFlowRole> changeOrgToWorkFlowRole(List<OrganizationVo> organizationList) {
        List<WorkFlowRole> workFlowRoles = new ArrayList<>();
        for (OrganizationVo organization : organizationList) {
            WorkFlowRole workFlowRole = new WorkFlowRole();
            if (organization.getChildNodes()!=null&&organization.getChildNodes().size()>0){
                workFlowRole.setChildNodes(changeOrgToWorkFlowRole(organization.getChildNodes()));
            }
            workFlowRole.setName(organization.getOrganizationName());
            workFlowRole.setId(organization.getCode());
            workFlowRole.setRoleType(RoleTypeEnum.ORGANIZATION.name());
            workFlowRoles.add(workFlowRole);
        }
        return workFlowRoles;
    }
}
