package com.tykj.workflowcore.workflow_editer.service.impl;


import com.alibaba.fastjson.JSONArray;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.workflowcore.base.result.ApiException;
import com.tykj.workflowcore.workflow_editer.dao.FormPageMapper;
import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.entity.FormPage;
import com.tykj.workflowcore.workflow_editer.entity.vo.FormPageVo;
import com.tykj.workflowcore.workflow_editer.entity.vo.PageFormPageVo;
import com.tykj.workflowcore.workflow_editer.service.FlowInfoService;
import com.tykj.workflowcore.workflow_editer.service.FormPageService;
import com.tykj.workflowcore.workflow_editer.service.WorkFlowService;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.*;

/**
 * ClassName:    PageEntityServiceImpl
 * Package:    com.tykj.service.impl
 * Description:
 * Datetime:    2021/3/3   13:16
 *
 * @Author: zsp
 */
@Service
public class FormPageServiceImpl implements FormPageService {

    @Autowired
    RuntimeService runtimeService;

    @Autowired
    private FormPageMapper formPageMapper;

    @Autowired
    FlowInfoService flowInfoService;

    @Autowired
    RepositoryService repositoryService;

    @Autowired
    WorkFlowService workFlowService;


    @Override
    public Integer savePage(@RequestBody FormPageVo inFormPageVo) {
        inFormPageVo.setCreateTime(new Date());
        FormPage formPage = inFormPageVo.toEntity();
        FormPage formPageSave = formPageMapper.save(formPage);
        Integer id = formPageSave.getId();
        return id;
    }

    @Override
    public void update(FormPage formPage) {
        //查询对应的processKey
        FlowsInfo byFlowKey = flowInfoService.findByFlowKey(formPage.getProcessKey());
        JSONArray pageIdArrays = JSONArray.parseArray(byFlowKey.getPageIds());
        if (pageIdArrays!=null){
            if (pageIdArrays.contains(formPage.getId())){
                //判断 byFlowKey 是否正在运行
                Integer state = byFlowKey.getState();
                // 0代表这个流程正在运行过程中
                if (state == 0){
                    throw new ApiException("该页面正在流程中运行,无法被修改");
                }
                //判断该流程是否存在正在运行的流程实例如果存在将不允许修改页面
                List<ProcessInstance> processInstances = workFlowService.queryUnfinishedProcessInstance(formPage.getProcessKey());
                if (processInstances.size()>0){
                    throw new ApiException("该页面正在流程中运行,无法被修改.请先停止所有正在运行的流程实例");
                }
            }
        }
        formPageMapper.save(formPage);
    }

    @Override
    public FormPage getPage(Integer id) {
        Optional<FormPage> byId = formPageMapper.findById(id);
        if (!byId.isPresent()){
            throw new ApiException("未找到该页面");
        }
        return byId.get();
    }

    @Override
    public void deletePage(Integer id) {
        FormPage formPage = formPageMapper.findById(id).get();
        formPageMapper.delete(formPage);
    }

    @Override
    public Page<FormPage> getAllPages(PageFormPageVo pageFormPageVo) {
        Specification<FormPage> formPageSpecification = specificationBuild(pageFormPageVo);
        Page<FormPage> formPagePage = formPageMapper.findAll(formPageSpecification, pageFormPageVo.getPageable());
        return formPagePage;
    }

    @Override
    public List<FormPage> getAllList(PageFormPageVo pageFormPageVo) {
        Specification<FormPage> formPageSpecification = specificationBuild(pageFormPageVo);
        List<FormPage> all = formPageMapper.findAll(formPageSpecification);
        return all;
    }

    @Override
    public Specification<FormPage> specificationBuild(PageFormPageVo pageFormPageVo) {
        PredicateBuilder<FormPage> and = Specifications.and();
        and.eq(!StringUtils.isEmpty(pageFormPageVo.getProcessKey()),"processKey",pageFormPageVo.getProcessKey());
        and.eq(pageFormPageVo.getPageName()!=null,"pageName",pageFormPageVo.getPageName());
        and.eq(pageFormPageVo.getPageDesc()!=null,"pageDesc",pageFormPageVo.getPageDesc());
        and.eq(pageFormPageVo.getCreateTime()!=null,"createTime",pageFormPageVo.getCreateTime());
        and.eq(pageFormPageVo.getCreateTime()!=null,"processKey",pageFormPageVo.getProcessKey());
        return and.build();
    }

    @Override
    public void checkIfWorking(String processKey) {
        //查询对应的processKey
        FlowsInfo byFlowKey = flowInfoService.findByFlowKey(processKey);
        //判断 byFlowKey 是否正在运行
        Integer state = byFlowKey.getState();
        // 0代表这个流程正在运行过程中
        if (state == 0) {
            throw new ApiException("该页面正在流程中运行,无法被修改");
        }
        //判断该流程是否存在正在运行的流程实例如果存在将不允许修改页面
        List<ProcessInstance> processInstances = workFlowService.queryUnfinishedProcessInstance(processKey);
        if (processInstances.size() > 0) {
            throw new ApiException("该页面正在流程中运行,无法被修改.请先停止所有正在运行的流程实例");
        }
    }

}
