package com.tykj.workflowcore.workflow_editer.util;

import com.tykj.workflowcore.base.util.SpringBeanService;
import com.tykj.workflowcore.workflow_editer.service.UserService;

import java.util.Map;
import java.util.Set;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class UserServiceBeanUtil
 * @packageName com.tykj.workflowcore.workflow_editer.util
 **/
public class UserServiceBeanUtil {

    public static UserService getUserService(SpringBeanService springBeanService) {
        Map<String, UserService> beansOfType = springBeanService.getApplicationContext().getBeansOfType(UserService.class);
        Set<String> strings = beansOfType.keySet();
        if (strings.size()>1){
            for (String key : strings) {
                if (!key.equals("defaultUserServiceImpl")){
                    return beansOfType.get(key);
                }
            }
        }
        return beansOfType.get("defaultUserServiceImpl");
    }



}
