package com.tykj.demo.datasource;



import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;


@Configuration
public class DataSourceConfig {
    @Primary  //表示当某一个类存在多个实例时，优先使用哪个实例
    @Bean(name = "test1DataSource")
    @ConfigurationProperties(prefix="spring.datasource.local")
    public DataSource test1DataSource() {
        return DataSourceBuilder.create().build();
    }
    @Bean(name = "test2DataSource")
    @ConfigurationProperties(prefix="spring.datasource.local1")
    public DataSource test2DataSource() {
        return DataSourceBuilder.create().build();
    }
}
