package com.tykj.demo.pojo.remote;

import com.tykj.demo.pojo.local.SignOne;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.stereotype.Component;

import javax.persistence.*;
import java.util.List;

/**
 * @author wen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("双签B")
public class SignTwo {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    @ApiModelProperty(value = "基地数", example = "基地数")
    @Column(name = "base_num")
    private String baseNum;
    @ApiModelProperty(value = "基地参观人数", example = "基地参观人数")
    @Column(name = "visitors_num")
    private String visitorsNum;
    @ApiModelProperty(value = "资源数", example = "资源数")
    @Column(name = "resources_num")
    private String resourcesNum;
    @ApiModelProperty(value = "活动数", example = "活动数")
    @Column(name = "use_num")
    private String useNum;
    @ApiModelProperty(value = "活动参与者人数", example = "活动参与者人数")
    @Column(name = "participants_num")
    private String participantsNum;
}
