package com.tykj.demo.controller;

import com.tykj.demo.pojo.file.Login;
import com.tykj.demo.pojo.file.SignLink;
import com.tykj.demo.pojo.local.SignOne;
import com.tykj.demo.pojo.remote.SignTwo;
import com.tykj.demo.service.SignService;
import com.tykj.demo.test1.dao.file.LoginDao;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.catalina.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wen
 */

@RestController
@Slf4j
@RequestMapping("/api")
@Api(tags = "sign", description = "双签Demo")
public class SignController {
    @Autowired
    private SignService signService;

    @ApiOperation(value = "查询双签A")
    @GetMapping("/findSignOne")
    public ResponseEntity findAll(Integer page, Integer pageSize) {
        Map<String, Object> map = new HashMap<>();
        Page<SignOne> homePages =signService.findAll(page,pageSize);
        map.put("homePages",homePages);
        return ResponseEntity.ok(map);
    }

    @ApiOperation(value = "保存双签A")
    @PostMapping("/saveSign")
    public ResponseEntity saveSign(@RequestBody SignOne signOne) {
        SignOne signAs = signService.saveSign(signOne);
        return ResponseEntity.ok(signAs);
    }


    @ApiOperation(value = "关联保存双签A表和B表")
    @PostMapping("/saveSignAll")
    public ResponseEntity saveSignAll(@RequestBody SignOne signOne) {
        //调用update保存
        SignTwo signTwo1 = signService.update(signOne);
        return ResponseEntity.ok(signTwo1);
    }


    @ApiOperation(value = "用户登陆")
    @PostMapping("/check")
    public String login(@RequestParam("username") String username, @RequestParam("password") String password, HttpSession session, Map<String,Object> map){
      Login login=signService.loadLoginByUsername(username);
      if (login==null){
          map.put("","用户名不存在");
          return "用户名或密码  不存在请重新输入";
      }
      String mm =login.getPassword();
      if (mm.equals(password)){
          session.setAttribute("loginUser",username);
          return "密码正确";
      }
      else {
          map.put("","用户名密码错误");
          return "请重新输入";
      }
    }
}


