package com.tykj.demo.pojo.local;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * @author wen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("双签A")
//自动添加更新时间
@EntityListeners(AuditingEntityListener.class)
public class SignOne {

    private Integer id;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "主键", example = "通主键Id")
    private Long tongID;

    @ApiModelProperty(value = "基地数", example = "基地数")
    @Column(name = "base_num")
    private String baseNum;

    @ApiModelProperty(value = "基地参观人数", example = "基地参观人数")
    @Column(name = "visitors_num")
    private String visitorsNum;

    @ApiModelProperty(value = "资源数", example = "资源数")
    @Column(name = "resources_num")
    private String resourcesNum;

    @ApiModelProperty(value = "资源使用量", example = "资源使用量")
    @Column(name = "resource_usage")
    private String  resourceUsage;

    @ApiModelProperty(value = "活动数", example = "活动数")
    @Column(name = "use_num")
    private String useNum;

    @ApiModelProperty(value = "活动参与者人数", example = "活动参与者人数")
    @Column(name = "participants_num")
    private String participantsNum;

    @ApiModelProperty(value = "专家数", example = "专家数")
    @Column(name = "expert_num")
    private String expertNum;

    @ApiModelProperty(value = "专家服务场次", example = "专家服务场次")
    @Column(name = "service_num")
    private String serviceNum;

    @ApiModelProperty(value = "更新时间", example = "更新时间")
   /* 自动添加更新时间
    @EntityListeners(AuditingEntityListener.class)*/
    @LastModifiedDate
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime time;


}
