package com.tykj.demo.service.Impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.demo.pojo.file.Login;
import com.tykj.demo.pojo.file.SignLink;
import com.tykj.demo.pojo.local.SignOne;
import com.tykj.demo.pojo.remote.SignTwo;
import com.tykj.demo.service.SignService;
import com.tykj.demo.test1.dao.file.LoginDao;
import com.tykj.demo.test1.dao.file.SignLinkDao;
import com.tykj.demo.test1.dao.local.SignOneDao;
import com.tykj.demo.test1.dao.remote.SignTwoDao;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import javax.security.auth.login.LoginException;
import java.util.*;

/**
 * @author wen
 */
@Service
@Slf4j
public  class SignServiceImpl implements SignService {
    @Autowired
    private SignOneDao signOneDao;
    @Autowired
    private SignTwoDao signTwoDao;
    @Autowired
    private SignLinkDao signLinkDao;
    @Autowired
    private LoginDao loginDao;

    @Override
    public Page<SignOne> findAll(Integer page, Integer pageSize) {
        //查询SignOne
        PageRequest pageable =PageRequest.of(page,pageSize);
        Page<SignOne> pageDetails =signOneDao.findAll(pageable);
        List<SignOne> user =pageDetails.getContent();
        for (SignOne p: user){
            System.out.println(p);
        }
        return pageDetails;
    }

    @Override
    public SignOne saveSign(SignOne signOne) {
        //保存双签
        return signOneDao.save(signOne);
    }

    @Override
    public SignTwo update(SignOne signOne) {
        //保存SignTwo的数据
        return signTwoDao.save(save(signOne));

    }
    public SignTwo save(SignOne signOne){
        //new一个SignTwo把SignTwo传入signOne中
        SignTwo signTwo= new SignTwo();
        signTwo.setId(signOne.getId());
        signTwo.setBaseNum(signOne.getBaseNum());
        signTwo.setVisitorsNum(signOne.getVisitorsNum());
        signTwo.setResourcesNum(signOne.getResourcesNum());
        signTwo.setUseNum(signOne.getUseNum());
        signTwo.setParticipantsNum(signOne.getParticipantsNum());
        return signTwo;
    }

    @Override
    public SignLink signOneMax(Integer id) {
        //1.去C表中获取存储的最大ID(maxId)
        SignLink signLink= signLinkDao.findTopById(id);
        // 注：第一去拿的时候，无这条数据，将这个值设置为0

        int signLinkId= 0;
        if(signLink!=null){
            //不为空获取数据
             signLinkId=signLink.getMaxId();
        }

        //2.根据maxId，查找A表中id大于maxId的对象集合,listA
        List<SignOne> signOnes=signOneDao.findSign(signLinkId);
        //3. 将listA转换为listB
        List<SignTwo> signTwos=new ArrayList<>();
        for (SignOne signOne: signOnes){
            SignTwo signTwo = new SignTwo();
            Integer ids =signOne.getId();
            String s =signOne.getBaseNum();
            String s1 =signOne.getVisitorsNum();
            String s2 =signOne.getResourcesNum();
            String s3 =signOne.getUseNum();
            String s4 =signOne.getParticipantsNum();
            signTwo.setId(ids);
            signTwo.setBaseNum(s);
            signTwo.setVisitorsNum(s1);
            signTwo.setResourcesNum(s2);
            signTwo.setUseNum(s3);
            signTwo.setParticipantsNum(s4);
            signTwos.add(signTwo);
        }
        //4.保存listB
        List<SignTwo> signTwoList=signTwoDao.saveAll(signTwos);
        //5.获取listB中的最大Id，将maxId替换为该Id，并保存maxId
        List<Integer> ids = new ArrayList<>();
        for (SignTwo signTwos1:signTwoList){
            Integer id1 = signTwos1.getId();
            ids.add(id1);
        }
        Integer max = Collections.max(ids);
        signLink.setMaxId(max);
        SignLink signLink1= signLinkDao.save(signLink);
        return signLink1;
    }

    @Override
    public Login loadLoginByUsername(String username) {
        return loginDao.findLoginByUsername(username);
    }

}

//    //1.去C表中获取存储的最大ID(maxId)
//    SignLink signLink= signLinkDao.findTopById();
//    // 注：第一去拿的时候，无这条数据，将这个值设置为0
//
//    int signLinkId= 0;
//        if(signLink!=null){
//        //不为空获取数据
//        signLinkId=signLink.getMaxId();
//        //2.根据maxId，查找A表中id大于maxId的对象集合,listA
//        List<SignOne> signOnes=signOneDao.findSign(signLinkId);
//        //3. 将listA转换为listB
//        List<SignTwo> signTwos=new ArrayList<>();
//        for (SignOne signOne: signOnes){
//            SignTwo signTwo = new SignTwo();
//            Integer ids =signOne.getId();
//            String s =signOne.getBase_num();
//            String s1 =signOne.getVisitors_num();
//            String s2 =signOne.getResources_num();
//            String s3 =signOne.getUse_num();
//            String s4 =signOne.getParticipants_num();
//            signTwo.setId(ids);
//            signTwo.setBase_num(s);
//            signTwo.setVisitors_num(s1);
//            signTwo.setResources_num(s2);
//            signTwo.setUse_num(s3);
//            signTwo.setParticipants_num(s4);
//            signTwos.add(signTwo);
//        }
//        //4.保存listB
//        List<SignTwo> signTwoList=signTwoDao.saveAll(signTwos);
//        //5.获取listB中的最大Id，将maxId替换为该Id，并保存maxId
//        List<Integer> ids = new ArrayList<>();
//        for (SignTwo signTwos1:signTwoList){
//            Integer id1 = signTwos1.getId();
//            ids.add(id1);
//        }
//        Integer max = Collections.max(ids);
//        signLink.setMaxId(max);
//        SignLink signLink1= signLinkDao.save(signLink);
//        return signLink1;
//    }else {
//        //为空的时候值为0
//        signLink.setMaxId(0);
//        return  signLink;
//    }
//}
//
//    private void tet(SignOne signOne) {
//
//        SignTwo signTwo = new SignTwo();
//
//
//        Integer id = signOne.getId();
//
//        signTwo.setId(id);
//
//    }


