package com.tykj.demo.service;

import com.tykj.demo.pojo.file.Login;
import com.tykj.demo.pojo.file.SignLink;
import com.tykj.demo.pojo.local.SignOne;
import com.tykj.demo.pojo.remote.SignTwo;
import org.springframework.data.domain.Page;

/**
 * @author wen
 */
public interface SignService {
    /**查询SignOne
     * @param
     * @return
     * */
    Page<SignOne> findAll(Integer page, Integer pageSize);
    /**保存双签
     * @param signOne
     * @return
     * */
    SignOne saveSign(SignOne signOne);
    /**更新SignOne时，SignTwo也更新部分数据
     * @param signOne
     * @return
     * */
    SignTwo update(SignOne signOne);
    /**查询SignTwo和SignOne和SignLink最大id进行对比保存
    * @param
    * @return
    * */
   SignLink signOneMax(Integer id);
    /**用户登陆
     * @param username，password
     * @return
     * */
   Login loadLoginByUsername(String username);
}
