package com.example.demo.controller;

import com.example.demo.dao.StudentDao;
import com.example.demo.pojo.Student;
import com.example.demo.service.StudentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * @author wen
 */
@RestController
@RequestMapping("/api")
@Api(tags = "练习", description = "练习demo")
public class StudentController {
    @Autowired
    private StudentService studentService;

    @ApiOperation(value = "查询单个")
   @GetMapping("/findOne")
    public Student finOne(Integer integer){
        return studentService.findOne(integer);
    }
    @ApiOperation(value = "查询全部")
   @GetMapping("/findAll")
    public ResponseEntity<List<Student>> findAll(){
        List<Student> students =studentService.findAll();
        return ResponseEntity.ok(students);
    }

    @ApiOperation(value = "条件查询")
    @PostMapping("/findTj")
    public ResponseEntity<Page<Student>> findTj(@RequestBody Student student){
        Page<Student> students =studentService.findTj(student);
     return ResponseEntity.ok(students);
    }

    @ApiOperation(value = "新增全部")
    @PostMapping("/findQb")
    public Student findQb(@RequestBody Student student){
        return  studentService.saveAll(student);
    }

    @ApiOperation(value = "模糊查询")
    @GetMapping("/findByName")
    public List<Student> findByName(String name) {
        return studentService.findFuzzy(name);
    }

    @ApiOperation(value = "根据ID删除")
    @DeleteMapping("/deleteId")
    public void deleteId(Integer id) {
        studentService.deleteOne(id);
    }

    @ApiOperation(value = "删除全部")
    @DeleteMapping("/deleteAll")
    public void deleteAll( ) {
        studentService.deleteAll();
    }

    @ApiOperation(value = "随机保存姓名年龄")
    @PostMapping("/saveRandomly")
    public Student saveRandomly(){
        return studentService.saveRandomly();
    }

    @ApiOperation(value = "查询各个年龄段")
    @GetMapping("/findAge")
    public  Map<String,List<Student>> findDigit(){
        return studentService.findDigit();
    }
    @ApiOperation(value = "查询各个年龄段男女数量")
    @GetMapping("/findGender")
    public  Map<String,List<Student>> findGender(){
        return studentService.findGender();
    }
    @ApiOperation(value = "查询男女各个年龄段数量")
    @GetMapping("/findGenderAge")
    public  Map<String,List<Student>> findDigitGender(){
        return studentService.findDigitGender();
    }
    @ApiOperation(value = "用*替换名字")
    @GetMapping("/replace")
    public List<Student> replace(){
        return studentService.replaceName();
    }

    @ApiOperation(value = "用*替换中间字")
    @GetMapping("/replaceMiddle")
    public List<Student> replaceMiddle(){
        return studentService.replace();
    }

    @ApiOperation(value = "按年查出每年的人数")
    @GetMapping("/findYear")
    public  Map<String, List<Student>> findYear(){

        return studentService.findYear();
    }
    @ApiOperation(value = "分页查询模糊查询名字 根据年份查询人数")
    @GetMapping("/findNameYear")
    public  Page<Student> findNameYear(@RequestParam int page, @RequestParam int size, @RequestParam String name,@RequestParam String year){
        return studentService.findNameYear(page, size, year,name );
    }

    @ApiOperation(value = "分页查询 根据年龄查询 并将这个年龄上下10岁的人都查出来")
    @GetMapping("/findObscureAge")
    public  Page<Student> findObscureAge(@RequestParam Integer page, @RequestParam Integer size, @RequestParam Integer age){
        return studentService.findAge(page,size,age);
    }
}
