package com.example.demo.dao;

import com.example.demo.pojo.Student;
import io.swagger.models.auth.In;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.support.JpaRepositoryImplementation;

import java.util.List;

/**
 * @author wen
 */
public interface StudentDao extends JpaRepository<Student,Integer>, JpaRepositoryImplementation<Student,Integer> {

    List<Student> findByNameContaining(String name);

    /**
     *
     * @param name
     * @param year 2022-01-01 00：00：00
     * @param year2 2022-12-31 23:59;59
     * @param pageable
     * @return
     */
    @Query(value = "select * from student  where name = ?1 and year between ?2 and ?3" ,nativeQuery = true)
    Page<Student> findNameYear(String name,String year,String year2,Pageable pageable);

}
