package com.example.demo.service.Impl;

import com.example.demo.dao.StudentDao;
import com.example.demo.pojo.Student;
import com.example.demo.service.StudentService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import lombok.extern.slf4j.Slf4j;
import org.apache.catalina.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.Jpa21Utils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.persistence.criteria.*;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;


/**
 * @author wen
 */
@Service
@Slf4j
//0-10 10-20 20-30
public class StudentImpl implements StudentService {
    @Autowired
    private StudentDao studentDao;


    String firstName = "张王李温";
    String studentName = "把豆腐干大范甘迪";
    String man = "男女";

    @Override
    public Student findOne(Integer id) {

        //根据iD保存
        Optional<Student> byId = studentDao.findById(id);
        return byId.orElse(null);
    }

    @Override
    public List<Student> findAll() {
        //保存全部
        return studentDao.findAll();
    }

    @Override
    public Page<Student> findTj(Student student) {
        PredicateBuilder<Student> builder = Specifications.and();
        //动态查询
        builder.eq(student.getId() != null, "id", student.getId());
        builder.eq(student.getName() != null, "name", student.getName());
        builder.eq(student.getAge() != null, "age", student.getAge());
        builder.eq(student.getGender() != null, "gender", student.getGender());
        builder.eq(student.getHeight() != null, "height", student.getHeight());

        //字段排序  分页
        Pageable pageable1 = PageRequest.of(0, 8, Sort.by("id"));

        //得到的是  分页的对象  并且里面的对象是有顺序的
        return studentDao.findAll(builder.build(), pageable1);
    }


    @Override
    public Student saveAll(Student student) {
        //新增全部
        return studentDao.save(student);
    }

    @Override
    public List<Student> findFuzzy(String name) {
        //模糊查询
        return studentDao.findByNameContaining(name);
    }

    @Override
    public void deleteOne(Integer id) {
        //根据ID删除
        Student student = studentDao.findById(id).get();
        studentDao.delete(student);
    }

    @Override
    public void deleteAll() {
        //删除全部
        studentDao.deleteAll();
    }

    @Override
    public Student saveRandomly() {
        //创建学生对象
        //随机生成出生年月日
        Student student = new Student();
        //对学生对象进行赋值  name age gender height
        String fist = getRandomString(firstName, 1);
        String name = getRandomString(studentName, 2);
        student.setName(fist + name);

        Integer randomAge = randomAge();
        student.setAge(randomAge + 20);

        String gender = getRandomString(man, 1);
        student.setGender(gender);

        student.setHeight(randomStringHeight() + 140 + "");

        Random rndYear=new Random();
        int year=rndYear.nextInt(22)+2000;

        Random rndMonth=new Random();
        int month=rndMonth.nextInt(12)+1;
        String s1 = month+"";
        if (s1.length()==1){
            s1 ="0"+month;
        }
        Random rndDay=new Random();
        int Day=rndDay.nextInt(30)+1;
        String s2 = Day+"";
        if (s2.length()==1){
            s2 ="0"+Day;
        }
        String s =year+"-"+s1+"-"+s2;
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate date =LocalDate.parse(s,df);
        student.setDate(date);
        //然后对学生对象进行保存
        //随机保存姓名年龄等字段
        return studentDao.save(student);
    }

    @Override
    //查看各个年龄段个数
    public  Map<String,List<Student>> findDigit() {
        //新建一个map用来存键值   TreeMap<>();是map排序（升序）
        Map<String,List<Student>> map=new TreeMap<>();
        //先查询全部的Student 的age年龄
        List<Student> result=studentDao.findAll();
        //遍历输出所有的age的字段
        result.forEach(student -> {
            //获取age字段
            int age=student.getAge();
            //然后对age进行分组分为 0-10    11-20    21-30   31-40...
            //然后设置查询条件
            if (age<=20){
                //判断map里面的键值在0到20之间的
                if (map.containsKey("0-20")){
                    //新建一个集合来获取map中的指定键值
                    List<Student> students = map.get("0-20");
                    //把得到的小于等20的student字段添加到students集合中
                    students.add(student);
                    //插入"0-20"和students
                    map.put("0-20",students);
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> students = new ArrayList<>();
                    students.add(student);
                    map.put("0-20",students);
                }
            }else if(age<=40){
                if (map.containsKey("21-40")){
                    List<Student> students =map.get("21-40");
                    students.add(student);
                    map.put("21-40",students);
                }else {
                    List<Student> students = new ArrayList<>();
                    students.add(student);
                    map.put("21-40",students);
                }
            }else if(age<=60) {
                if (map.containsKey("41-60")) {
                    List<Student> students = map.get("41-60");
                    students.add(student);
                    map.put("41-60", students);
                } else {
                    List<Student> students = new ArrayList<>();
                    students.add(student);
                    map.put("41-60", students);
                }
            }
            else if(age<=80) {
                if (map.containsKey("61-80")) {
                    List<Student> students = map.get("61-80");
                    students.add(student);
                    map.put("61-80", students);
                } else {
                    List<Student> students = new ArrayList<>();
                    students.add(student);
                    map.put("61-80", students);
                }
            }
            else if(age<=100) {
                if (map.containsKey("81-100")) {
                    List<Student> students = map.get("81-100");
                    students.add(student);
                    map.put("81-100", students);
                } else {
                    List<Student> students = new ArrayList<>();
                    students.add(student);
                    map.put("81-100", students);
                }
            }
        });
        return map;
    }

    @Override
    //查看各个年龄段男女的个数
    public Map<String, List<Student>> findGender() {

        //新建一个map用来存键值   TreeMap<>();是map排序（升序）
         Map<String,List<Student>> map=new TreeMap<>();
        //先查询全部的Student 的age年龄
        List<Student> result=studentDao.findAll();
        //遍历输出所有的age的字段
        result.forEach(student -> {
            int age=student.getAge();
            if (age<=20) {
                if (map.containsKey("0-20")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> students = map.get("0-20");
                    //把得到的小于等20的student字段添加到students集合中
                    students.add(student);
                    //插入"0-20"和students
                    map.put("0-20", students);
                    if (map.containsKey("男")) {
                        List<Student> genders = map.get("男");
                        map.put("男", genders);
                    }
                    }else {
                    //如果没有数据就新建一个集合
                    List<Student> students = new ArrayList<>();
                    students.add(student);
                    map.put("0-20",students);
                }
                }
            if (age>=21 && age<=40) {
                if (map.containsKey("21-40")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> students = map.get("21-40");
                    //把得到的小于等20的student字段添加到students集合中
                    students.add(student);
                    //插入"0-20"和students
                    map.put("21-40", students);
                    if (map.containsKey("男")) {
                        List<Student> genders = map.get("男");
                        map.put("男", genders);
                    }
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> students = new ArrayList<>();
                    students.add(student);
                    map.put("21-40",students);
                }
            }
            if (age>=41 && age<=60) {
                if (map.containsKey("41-60")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> students = map.get("41-60");
                    //把得到的小于等20的student字段添加到students集合中
                    students.add(student);
                    //插入"0-20"和students
                    map.put("41-60", students);
                    if (map.containsKey("男")) {
                        List<Student> genders = map.get("男");
                        map.put("男", genders);
                    }
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> students = new ArrayList<>();
                    students.add(student);
                    map.put("41-60",students);
                }
            }
            if (age>=61 && age<=80) {
                if (map.containsKey("61-80")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> students = map.get("61-80");
                    //把得到的小于等20的student字段添加到students集合中
                    students.add(student);
                    //插入"0-20"和students
                    map.put("61-80", students);
                    if (map.containsKey("男")) {
                        List<Student> genders = map.get("男");
                        map.put("男", genders);
                    }
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> students = new ArrayList<>();
                    students.add(student);
                    map.put("61-80",students);
                }
            }
            if (age>=81 && age<=100) {
                if (map.containsKey("81-100")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> students = map.get("81-100");
                    //把得到的小于等20的student字段添加到students集合中
                    students.add(student);
                    //插入"0-20"和students
                    map.put("81-100", students);
                    if (map.containsKey("男")) {
                        List<Student> genders = map.get("男");
                        map.put("男", genders);
                    }
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> students = new ArrayList<>();
                    students.add(student);
                    map.put("81-100",students);
                }
            }
        });
        return map;
    }
    @Override
    //查看男女各个年龄段的个数
    public Map<String, List<Student>> findDigitGender() {
        Map<String,List<Student>> map=new HashMap<>();
        //先查询全部的Student 的age年龄
        List<Student> result=studentDao.findAll();
        //遍历输出所有的age的字段
        result.forEach(student -> {
                String gender=student.getGender();
                int age=student.getAge();
                if (age<=20 && gender.equals("男")) {
                    if (map.containsKey("男:0-20")) {
                        //新建一个集合来获取map中的指定键值
                        List<Student> studentMan = map.get("男:0-20");
                        //把得到的小于等20的student字段添加到students集合中
                        studentMan.add(student);
                        //插入"0-20"和students
                        map.put("男:0-20", studentMan);
                        if (map.containsKey("男")) {
                            List<Student> genders = map.get("男");
                            map.put("男", genders);
                        }
                    }else {
                        //如果没有数据就新建一个集合
                        List<Student> studentMan = new ArrayList<>();
                        studentMan.add(student);
                        map.put("男:0-20",studentMan);
                    }
                }
                if (age<=20 && gender.equals("女")) {
                    if (map.containsKey("女:0-20")) {
                        //新建一个集合来获取map中的指定键值
                        List<Student> studentWoman = map.get("女:0-20");
                        //把得到的小于等20的student字段添加到students集合中
                        studentWoman.add(student);
                        //插入"0-20"和students
                        map.put("女:0-20", studentWoman);
                        if (map.containsKey("女")) {
                            List<Student> genders = map.get("女");
                            map.put("女", genders);
                        }
                    }else {
                        //如果没有数据就新建一个集合
                        List<Student> studentWoman = new ArrayList<>();
                        studentWoman.add(student);
                        map.put("女:0-20",studentWoman);
                    }
                }
                if (age>21 && age<=40  && gender.equals("男")) {
                if (map.containsKey("男:21-40")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> studentMan = map.get("男:21-40");
                    //把得到的小于等20的student字段添加到students集合中
                    studentMan.add(student);
                    //插入"0-20"和students
                    map.put("男:21-40", studentMan);
                    if (map.containsKey("男")) {
                        List<Student> genders = map.get("男");
                        map.put("男", genders);
                    }
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> studentMan = new ArrayList<>();
                    studentMan.add(student);
                    map.put("男:21-40",studentMan);
                }
            }
            if (age>21 && age<=40 && gender.equals("女")) {
                if (map.containsKey("女:21-40")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> studentWoman = map.get("女:21-40");
                    //把得到的小于等20的student字段添加到students集合中
                    studentWoman.add(student);
                    //插入"0-20"和students
                    map.put("女:21-40", studentWoman);
                    if (map.containsKey("女")) {
                        List<Student> genders = map.get("女");
                        map.put("女", genders);
                    }
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> studentWoman = new ArrayList<>();
                    studentWoman.add(student);
                    map.put("女:21-40",studentWoman);
                }
            }
            if (age>41 && age<=60  && gender.equals("男")) {
                if (map.containsKey("男:41-60")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> studentMan = map.get("男:41-60");
                    //把得到的小于等20的student字段添加到students集合中
                    studentMan.add(student);
                    //插入"0-20"和students
                    map.put("男:41-60", studentMan);
                    if (map.containsKey("男")) {
                        List<Student> genders = map.get("男");
                        map.put("男", genders);
                    }
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> studentMan = new ArrayList<>();
                    studentMan.add(student);
                    map.put("男:41-60",studentMan);
                }
            }
            if (age>41 && age<=60 && gender.equals("女")) {
                if (map.containsKey("女:41-60")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> studentWoman = map.get("女:41-60");
                    //把得到的小于等20的student字段添加到students集合中
                    studentWoman.add(student);
                    //插入"0-20"和students
                    map.put("女:41-60", studentWoman);
                    if (map.containsKey("女")) {
                        List<Student> genders = map.get("女");
                        map.put("女", genders);
                    }
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> studentWoman = new ArrayList<>();
                    studentWoman.add(student);
                    map.put("女:41-60",studentWoman);
                }
            }
            if (age>61 && age<=80  && gender.equals("男")) {
                if (map.containsKey("男:61-80")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> studentMan = map.get("男:61-80");
                    //把得到的小于等20的student字段添加到students集合中
                    studentMan.add(student);
                    //插入"0-20"和students
                    map.put("男:61-80", studentMan);
                    if (map.containsKey("男")) {
                        List<Student> genders = map.get("男");
                        map.put("男", genders);
                    }
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> studentMan = new ArrayList<>();
                    studentMan.add(student);
                    map.put("男:61-80",studentMan);
                }
            }
            if (age>61 && age<=80 && gender.equals("女")) {
                if (map.containsKey("女:61-80")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> studentWoman = map.get("女:61-80");
                    //把得到的小于等20的student字段添加到students集合中
                    studentWoman.add(student);
                    //插入"0-20"和students
                    map.put("女:61-80", studentWoman);
                    if (map.containsKey("女")) {
                        List<Student> genders = map.get("女");
                        map.put("女", genders);
                    }
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> studentWoman = new ArrayList<>();
                    studentWoman.add(student);
                    map.put("女:61-80",studentWoman);
                }
            }
            if (age>81 && age<=100  && gender.equals("男")) {
                if (map.containsKey("男:81-100")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> studentMan = map.get("男:81-100");
                    //把得到的小于等20的student字段添加到students集合中
                    studentMan.add(student);
                    //插入"0-20"和students
                    map.put("男:81-100", studentMan);
                    if (map.containsKey("男")) {
                        List<Student> genders = map.get("男");
                        map.put("男", genders);
                    }
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> studentMan = new ArrayList<>();
                    studentMan.add(student);
                    map.put("男:81-100",studentMan);
                }
            }
            if (age>81 && age<=100 && gender.equals("女")) {
                if (map.containsKey("女:81-100")) {
                    //新建一个集合来获取map中的指定键值
                    List<Student> studentWoman = map.get("女:81-100");
                    //把得到的小于等20的student字段添加到students集合中
                    studentWoman.add(student);
                    //插入"0-20"和students
                    map.put("女:81-100", studentWoman);
                    if (map.containsKey("女")) {
                        List<Student> genders = map.get("女");
                        map.put("女", genders);
                    }
                }else {
                    //如果没有数据就新建一个集合
                    List<Student> studentWoman = new ArrayList<>();
                    studentWoman.add(student);
                    map.put("女:81-100",studentWoman);
                }
            }
        });
        return map;
    }
    //输出名字的时候三个字的名字第三个字打*
    //两个字的名字第二个字打*
    @Override
    //替换最后一个字为*
    public List<Student> replaceName() {
        List<Student> students =studentDao.findAll();
        students.forEach(student -> {
        String fist = getRandomString(firstName, 1);
        String name = getRandomString(studentName, 2);
        String replaceTwo =name.substring(0,name.length() -1)+ "*";
        student.setName(fist+replaceTwo);
        });
        return students;
    }

    @Override
    public List<Student> replace() {
        //替换中间字为*
        List<Student> s =studentDao.findAll();
        s.forEach(student -> {
            String fist = getRandomString(firstName, 1);
            String name = getRandomString(studentName, 2);
            StringBuilder sb =new StringBuilder(name);
            sb.replace(0,1,"*");
            student.setName(fist+sb);

        });
        return s;
    }

    @Override
    public  Map<String, List<Student>> findYear() {
        //按年过滤出每年有那些人
        Map<String, List<Student>> collect = studentDao.findAll().stream().collect(Collectors.groupingBy(student -> {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate date = student.getDate();
            String strDate = date.format(df);
            return strDate.substring(0, 4);
        }));


        //按年过滤出每年有那些人
        Map<String,List<Student>> map=new HashMap<>();

        List<Student> students=studentDao.findAll();

        students.forEach(student -> {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate date =student.getDate();
            String strDate =date.format(df);
          String s=  strDate.substring(0,4);


            if (map.containsKey(s)){
                List<Student> stu = map.get(s);
                //把得到的小于等20的student字段添加到students集合中
                stu.add(student);
                //插入"0-20"和students
                map.put(s,stu);

            }else {
                List<Student> list = new ArrayList<>();
                //如果没有数据就新建一个集合
                list.add(student);
                map.put(s,list);
            }
});
        return map;
    }

    @Override
    //分页查询 模糊查询名字 根据年份查询人数
    public Page<Student> findNameYear(int page, int size, String year,String name) {
//        Sort sort=Sort.by(Sort.Direction.DESC,year);
        Pageable pageable=PageRequest.of(page,size);
//        Page<Student> studentList=null;
        PredicateBuilder<Student> and = Specifications.and();
        and.like(name != null, "name", "%" + name + "%");
        and.le(  year != null, "date", LocalDate.parse(year + "-12-31"));
        and.ge(  year != null, "date", LocalDate.parse(year + "-01-01"));

        Specification<Student> spec = and.build();
        return studentDao.findAll(spec, pageable);
    }

    @Override
    //分页查询 根据年龄查询 并将这个年龄上下10岁的人都查出来
    public Page<Student> findAge(Integer page, Integer size, Integer age) {

        Pageable pageable=PageRequest.of(page,size);

        PredicateBuilder<Student> and=Specifications.and();
        and.le(age !=null,"age",age+10);
        and.ge(age !=null,"age",age-10);

        Specification<Student> spec=and.build();
        return studentDao.findAll(spec,pageable);
    }


    public static String getRandomString(String str, Integer length){
        Random random=new Random();
        StringBuilder sb=new StringBuilder();
        for(int i = 0; i<length; i++){
            int number=random.nextInt(str.length());
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static Integer randomAge(){
        long round = Math.round(Math.random() * 50);
        return new Long(round).intValue();
    }
    public static Integer randomStringHeight(){
        long round = Math.round(Math.random() * 50);

        return new Long(round).intValue();
    }


    public static void main(String[] args) {
    }

}