package com.example.demo.service.Impl;

import com.example.demo.dao.StudentDao;
import com.example.demo.pojo.Student;
import com.example.demo.service.StudentService;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;


/**
 * @author wen
 */
@Service
@Slf4j

public class StudentImpl implements StudentService {
    @Autowired
    private StudentDao studentDao;


    @Override
    public Student findOne(Integer id) {
        Optional<Student> byId = studentDao.findById(id);
        if (byId.isPresent()){
            Student student = byId.get();
            return student;
        }
        return null;
    }

    @Override
    public List<Student> findAll() {
        return studentDao.findAll();
    }

    @Override
    public Page<Student> findTj(Student student) {

        PredicateBuilder<Student> builder = Specifications.and();
        //动态查询
        builder.eq(student.getId()     !=null,"id",student.getId());
        builder.eq(student.getName()   !=null,"name",student.getName());
        builder.eq(student.getAge()    !=null,"age",student.getAge());
        builder.eq(student.getGender() !=null,"gender",student.getGender());
        builder.eq(student.getHeight() !=null,"height",student.getHeight());

        //字段排序  分页
        Pageable pageable1 = PageRequest.of(0,8, Sort.by("id"));

        //得到的是  分页的对象  并且里面的对象是有顺序的
        return studentDao.findAll(builder.build(), pageable1);
    }


    @Override
    public Student saveAll(Student student ) {
        return studentDao.save(student);
    }

    @Override
    public List<Student> findFuzzy(String name) {
        return studentDao.findByNameContaining(name);
    }

    @Override
    public void deleteOne(Integer id) {
        Student student =studentDao.findById(id).get();
        studentDao.delete(student);
    }

    @Override
    public void deleteAll(Student student) {
        studentDao.delete(student);
    }


}