package com.example.demo.service;

import com.example.demo.pojo.Student;
import org.springframework.data.domain.Page;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * @author wen
 */
public interface StudentService {
     /**根据ID单个查询
      * @return*/
     Student findOne(Integer id);

    /**
     * 查询全部
     * @return
     */
     List<Student> findAll();

    /**
     * 条件查询
     * @param student
     * @return
     */
    Page<Student> findTj(Student student);



    /**
     * 新增全部
     * @param student
     * @return
     */
     Student saveAll(Student student);

    /**
     * 模糊查询
     * @param name
     * @return
     */
    List<Student>  findFuzzy(String name);

    /**
     * 根据id删除
     * @param id
     */
    void deleteOne(Integer id);

    /**
     * 删除全部
     * @param
     */
    void deleteAll();

    /**
     * 随机保存姓名年龄等字段
     * @param
     * @return
     */
    Student saveRandomly();

    /**
     * 查询排序0-10 11-20 21-30 31-40 41-50 51-60
     * @param
     * @return
     */
    Map<String,List<Student>> findDigit();

    /**
     * 查询各个年龄段的人男女
     * @return
     */
    Map<String,List<Student>> findGender();

    /**
     * 查询男女各个年龄段的数量
     * @return0
     */
    Map<String,List<Student>> findDigitGender();

    /**替换最后一个字为*
     *
     * @return
     */
    List<Student> replaceName();

    /**
     * 替换中间字为*
     * @return
     */
    List<Student> replace();

    /**
     * /按年过滤出每年有那些人
     * @return
     */
    Map<String, List<Student>> findYear();

    /**
     * 分页查询 名字模糊查询 输入年份查询人数
     * @param
     * @return
     */
    Page<Student> findNameYear(String name ,Integer page, Integer pageSize,Integer year);
}
