package com.example.demo.controller;

import com.example.demo.pojo.HomePage;
import com.example.demo.pojo.Sub;
import com.example.demo.service.ContainService;
import com.example.demo.service.HomePageService;
import com.example.demo.service.SubService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author wen
 */
@RestController
@RequestMapping("/api")
@Api(tags = "百度贴吧", description = "贴吧主页")
public class HomeController {
    @Autowired
    private HomePageService homePageService;
    @Autowired
    private SubService subService;

    @Autowired
    private ContainService containService;
    @GetMapping("/honePage")
    @ApiOperation(value = "帖子主页")
    public ResponseEntity findAll(){
        List<HomePage>homePages =homePageService.findAll();
        return ResponseEntity.ok(homePages);
    }

//    @GetMapping("/ziHonePage")
//    @ApiOperation(value = "用户帖子")
//    public ResponseEntity linkAll(){
//        List<Sub> subs =subService.findByResponder(0);
//        return ResponseEntity.ok(subs);
//    }

    @PostMapping ("/savePage")
    @ApiOperation(value = "保存主贴的接口")
    public HomePage saveAll(@RequestBody HomePage homePage){
        return homePageService.saveAll(homePage);
    }
    @PostMapping("/userSub")
    @ApiOperation(value = "保存回复贴子")
    public Sub saveOne(@RequestBody Sub sub){
        return subService.saveOne(sub);
    }

    @PostMapping("/saveUser")
    @ApiOperation(value ="自己回复帖子" )
    public Sub saveUser(@RequestBody Sub sub){
        return subService.saveUser(sub);
    }

    @GetMapping("/ziHonePage")
    @ApiOperation(value = "用户帖子")
    public ResponseEntity finAll(){
        List<HomePage> contains =homePageService.finAll();
        return ResponseEntity.ok(contains);
    }

}






















