package com.example.demo.service.impl;

import com.example.demo.dao.HomePageDao;
import com.example.demo.dao.SubDao;
import com.example.demo.pojo.HomePage;
import com.example.demo.pojo.Sub;
import com.example.demo.service.HomePageService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;

/**
 * @author wen
 */
@Service
@Slf4j
public class HomePageServiceImpl implements HomePageService {

    @Autowired
    private HomePageDao homePageDao;
    @Autowired
    private SubDao subDao;

    @Override
    public List<HomePage> finAll() {
//        List<HomePage> homePages=homePageDao.findByResponderId(1);
//
//        List<Sub> ljSub=subDao.findByResponder(0);
//        for (Sub sub : ljSub) {
//            Integer integer = sub.getId();
//            List<Sub> subs1 = subDao.findByResponder(integer);
//            sub.setSubs(subs1);
//        }
        //先查出来主贴的
        List<HomePage> homePages = homePageDao.findAll();
        //遍历主贴
        homePages.forEach(homePage -> {
            //根据主贴的id查询字帖的集合
            List<Sub> allByResponderId = subDao.findAllByResponderId(homePage.getId());
            homePage.setSubList(allByResponderId);
        });

        return homePages;
    }

    @Override
    public List<HomePage> findAll() {
        return homePageDao.findAll();
    }

    @Override
    public HomePage saveAll(HomePage homePage) {
        HomePage homePages =homePageDao.save(homePage);
        return homePages;
    }
}








































































































































