package com.example.demo.dao;

import com.example.demo.pojo.HomePage;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

/**
 * @author wen
 */
public interface HomePageDao extends JpaRepository<HomePage,Integer>, JpaSpecificationExecutor<HomePage>
{
    @Query(value="select * from user where id > (:id)",nativeQuery = true)
    Page<HomePage> findById(@Param("id") Integer id, Pageable pageable);
    HomePage findByUsername(HomePage username);
    /**
     * 根据用户姓名，分页查询用户列表（使用原生SQL语句）
     */
    @Query(value = "SELECT * FROM tb_user WHERE user_name LIKE %:name%", nativeQuery = true)
    public Page<HomePage> getUserPageByNameSQL(@Param("name")String userName, Pageable pageable);


    List<HomePage> findHomePageById(Integer id);

    List<HomePage> findByResponderId(Integer id);
}
