package com.example.demo.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author wen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("主页")
public class HomePage {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "主键id", example = "1")
    private Integer id;
    /**用户名*/
    @ApiModelProperty(value = "姓名", example = "有驾小助手")
    private String username;
    /**@JsonFormat(pattern = "yyyy-mm-dd")*/
    /**时间*/
    @Temporal(TemporalType.DATE)
    private Date date;
    /**标题*/
    @ApiModelProperty(value = "标题", example = "【汽车】30万内最速电车之争")
    private String title;
    /**内容*/
    @ApiModelProperty(value = "内容", example = "提到新能源汽车，很多人首先想到的就是特斯拉。在Model 3国产后，月销量破万的数据似乎更是加强了特斯拉的“神话”。当特斯拉还在主打Model 3的时候，国产电动汽车元老——比亚迪再推出汉EV。并且以27万+的超低价格为消")
    private String content;

    /**连接子贴的id*/
    private  Integer responderId;
    @Transient
    private List<Sub> subList;
}
