package com.example.demo.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author wen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("主页子接口,点击进入的用户帖子")

public class Sub {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    private Integer responder;
    /**标题*/
    private String ownContent;
    /**用户名*/
    private String postedBy;
    /**发帖内容*/
    private String postContent;
    /**回复内容*/
    private String replyContent;
    /**连接主贴的id*/
    private  Integer responderId;
    /**时间*/
    @JsonFormat(pattern = "yyyy-mm-dd")
    private Date subDate;

    @Transient
    private List<Sub>subs;



}
