package com.example.demo.service.impl;

import com.example.demo.dao.HomePageDao;
import com.example.demo.dao.SubDao;
import com.example.demo.pojo.HomePage;
import com.example.demo.pojo.Sub;
import com.example.demo.service.HomePageService;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author wen
 */
@Service
@Slf4j

public class HomePageServiceImpl implements HomePageService {

    @Autowired
    private HomePageDao homePageDao;
    @Autowired
    private SubDao subDao;


    @Override
    public Page<HomePage> findByIdHomePage(Integer page, Integer pageSize) {
        PageRequest pageable =PageRequest.of(page,pageSize);
        Page<HomePage> pageDetails =homePageDao.findAll(pageable);
        List<HomePage> user =pageDetails.getContent();
        for (HomePage p: user){
            System.out.println(p);
        }
        return pageDetails;
    }


    @Override
    public List<HomePage> findfuAll() {

//        List<S//        List<HomePage> homePages=homePageDao.fin
//
//        dByResponderId(1);
////ub> ljSub=subDao.findByResponder(0);
//        for (Sub sub : ljSub) {
//            Integer integer = sub.getId();
//            List<Sub> subs1 = subDao.findByResponder(integer);
//            sub.setSubs(subs1);
//        }
        //先查出来主贴的
        List<HomePage> homePages = homePageDao.findAll();
        //遍历主贴
        homePages.forEach(homePage -> {
            //根据主贴的id查询字帖的集合
            List<Sub> allByResponderId = subDao.findAllByResponderId(homePage.getId());
            homePage.setSubList(allByResponderId);
        });
        return homePages;
    }

    @Override
    public List<HomePage> findziAll() {
        return homePageDao.findAll();
    }

    @Override
    public HomePage saveAll(HomePage homePage) {
        HomePage homePages =homePageDao.save(homePage);
        return homePages;
    }

    @Override
    public void deleteZhu(HomePage homePage) {
        homePageDao.delete(homePage);
    }


}








































































































































