package com.zjty.switches.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import java.util.Map;

@SuppressWarnings({"SpringAutowiredFieldsWarningInspection", "SpringComponentScan"})
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(
        entityManagerFactoryRef = "entityManagerFactoryLocation",
        transactionManagerRef = "transactionManagerLocation",
        basePackages = {"com.ex"}
)
@EnableConfigurationProperties(JpaProperties.class)
public class Remote1DataConfig {
    @Autowired
    @Qualifier("remote1DataSource")
    private DataSource locationDataSource;
    @Autowired
    private JpaProperties jpaProperties;
    @Autowired
    private HibernateProperties properties;
    @Primary
    @Bean(name = "entityManagerLocation")
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        return entityManagerFactoryLocation(builder).getObject().createEntityManager();
    }

    @Primary
    @Bean(name = "entityManagerFactoryLocation")
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryLocation(EntityManagerFactoryBuilder builder) {
        return builder
                .dataSource(locationDataSource)
                .properties(properties.determineHibernateProperties(jpaProperties.getProperties(), new
                        HibernateSettings()))
                .packages("com.zjm.synchronous.exchange.entity")
                .persistenceUnit("locationPersistenceUnit")
                .build();
    }

    private Map<String, String> getVendorProperties() {
        return jpaProperties.getProperties();
    }

    @Primary
    @Bean(name = "transactionManagerLocation")
    public PlatformTransactionManager transactionManagerLocation(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(entityManagerFactoryLocation(builder).getObject());
    }
}


