package com.zjty.switches.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManager;
import javax.sql.DataSource;
import java.util.Map;

@SuppressWarnings("ALL")
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(
        entityManagerFactoryRef = "entityManagerFactoryRemote2",
        transactionManagerRef = "transactionManagerRemote2",
        basePackages = {"com.ex"}
)
@EnableConfigurationProperties(JpaProperties.class)
public class Remote2DataConfig {
    @Autowired
    @Qualifier("remote2DataSource")
    private DataSource remoteDataSource;

    @Autowired
    private HibernateProperties properties;

    @Bean(name = "entityManagerRemote2")
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        return entityManagerFactoryRemote2(builder).getObject().createEntityManager();
    }

    @Bean(name = "entityManagerFactoryRemote2")
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryRemote2(EntityManagerFactoryBuilder builder) {
        return builder
                .dataSource(remoteDataSource)
                .properties(properties.determineHibernateProperties(jpaProperties.getProperties(), new
                        HibernateSettings()))
                .packages(
                        "com.zjm.synchronous.bas.base.ls.entity")
                .persistenceUnit("remotePersistenceUnit2")
                .build();
    }

    @Autowired
    private JpaProperties jpaProperties;


    private Map<String, String> getVendorProperties() {
        return jpaProperties.getProperties();
    }


    @Bean(name = "transactionManagerRemote2")
    public PlatformTransactionManager transactionManagerRemote(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(entityManagerFactoryRemote2(builder).getObject());
    }
}

