package com.zjty.catalog.domain;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

@AllArgsConstructor
@NoArgsConstructor
//@Entity
@Data
public class Column {
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Integer id;//主键
    private String name;//列名
    private String type;//数据类型
    private Integer length;//长度
    private String defaultName;//默认数据
    private Integer primaryKey;//0-非主键 1-主键
    private Integer empty;//0-空 1-非空
    private Integer unsigned;//0-有符号 1-无符号
    private Integer increment;//0-非自增 1-自增
    private Integer zeroFill;//0-不补零 1-补零
    private String note;//注释
    private Integer tableId;//外键，所属表id
}
