package com.zjty.catalog.service.impl;

import com.zjty.catalog.base.response.ServerResponse;
import com.zjty.catalog.domain.Column;
import com.zjty.catalog.domain.Table;
import com.zjty.catalog.service.BuildTableService;
import com.zjty.catalog.utils.DBConnectionUtil;
import org.springframework.stereotype.Service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

@Service
public class BuildTableServiceImpl implements BuildTableService {

    @Override
    public ServerResponse buildTableService(String dbName,Table table, List<Column> columnList) {
        Connection connection = DBConnectionUtil.databaseConnection(dbName);
        PreparedStatement preparedStatement = null;
        String sql = "";
        String startSql = "CREATE TABLE `" + dbName + "`.`" + table.getName() + "`(\r\n";
        String centerSql = "";
        String endSql = ") ENGINE=" + table.getEngine() + " CHARSET=" + table.getCoding() + " COLLATE=" + table.getCollate() + ";";
        for(Column column : columnList){
            centerSql += "`" + column.getName() + "` " + column.getType() + "(" + column.getLength() + ")";
            if(column.getUnsigned() == 1){
                centerSql += " UNSIGNED";
            }
            if(column.getZeroFill() == 1){
                centerSql += " ZEROFILL";
            }
            if(column.getEmpty() == 1){
                centerSql += " NOT NULL";
            }
            if(column.getIncrement() == 1){
                centerSql += " AUTO_INCREMENT";
            }
            if(column.getDefaultName() != null){
                centerSql += " DEFAULT '" + column.getDefaultName() + "'";
            }
            if(column.getNote() != null){
                centerSql += " COMMENT '" + column.getNote() + "'";
            }
            if(column.getPrimaryKey() == 1){
                endSql = "PRIMARY KEY (`" + column.getName() + "`)\r\n" + endSql;
            }
            centerSql += ",\r\n";
        }
        sql = startSql + centerSql + endSql;
        System.out.println(sql);
        try {
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.execute();
        } catch (SQLException e) {
            e.printStackTrace();
        }finally {
            try {
                preparedStatement.close();
                connection.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return ServerResponse.success();
    }


}
