package com.zjty.ds.misc.config;

import com.google.common.collect.Sets;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * fusion-platform.
 *
 * @author : Matrix [xhyrzldf@gmail.com]
 * 19-1-10 .
 */
@Configuration
@EnableSwagger2
public class Swagger2Config {
    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .produces(Sets.newHashSet("application/json"))
                .consumes(Sets.newHashSet("application/json"))
                .protocols(Sets.newHashSet("http"))
                .apiInfo(apiInfo())
                .forCodeGeneration(true)
                .useDefaultResponseMessages(true)
//                .globalResponseMessage(RequestMethod.GET, getResMsg())
                .select()
                // 指定controller存放的目录路径
                .apis(RequestHandlerSelectors.withClassAnnotation(AutoDocument.class))
                .paths(PathSelectors.any())
                .build();
//                .apiInfo(apiInfo())
//                .securitySchemes(Collections.singletonList(securityScheme()))
//                .securityContexts(Collections.singletonList(securityContext()));
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                // 文档标题
                .title("XXX项目的API对接文档")
                // 文档描述
                .description("XXX项目的接口文档与测试页面")
                .termsOfServiceUrl("http://192.168.1.1:8080/ty-note/ty-note-blackend.git")
                .version("v 0.1.0")
                .contact(new Contact("xxx", "http://localhost:8080/xxx", "ty@example.com"))
                .build();
    }
}
