package com.zjty.ftp.service.impl;

import com.zjty.ftp.service.FileUploadService;
import com.zjty.ftp.base.response.ServerResponse;
import com.zjty.ftp.entity.FileReturn;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Service
public class FileUploadServiceImpl implements FileUploadService {

    @Value("${file.address}")
    private String fileAddress;

    /**
     * 前台文件上传
     * @param request
     * @return
     */
    @Override
    public ServerResponse fileUpload(HttpServletRequest request) {
        List<MultipartFile> multipartFiles = ((MultipartHttpServletRequest)request).getFiles("file");
        List<FileReturn> fileReturns = new ArrayList<>();
        for(MultipartFile multipartFile:multipartFiles){
            InputStream is = null;
            BufferedInputStream bis = null;
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            FileReturn fileReturn = new FileReturn();
            String sourceName = multipartFile.getOriginalFilename();
            //String suffix = sourceName.substring(sourceName.lastIndexOf("."));
            //String fileName = UUID.randomUUID().toString() + suffix;
            //不存在该目录，创建目录
            File file = new File(fileAddress);
            if(!file.exists()){
                file.mkdirs();
            }
            String savePath = file.getAbsolutePath() + "/" + sourceName;
            fileReturn.setName(sourceName);
            fileReturn.setPath(savePath);
            fileReturns.add(fileReturn);
            File createFile = new File(savePath);
            try {
                is = multipartFile.getInputStream();
                bis = new BufferedInputStream(is);
                fos = new FileOutputStream(createFile);
                bos = new BufferedOutputStream(fos);
                int len = -1;
                byte[] b = new byte[1024];
                while ((len = bis.read(b)) != -1){
                    bos.write(b,0,len);
                }
            } catch (IOException e) {
                e.printStackTrace();
            }finally {
                try {
                    bis.close();
                    is.close();
                    bos.close();
                    fos.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ServerResponse.success(fileReturns);
    }
}
