package com.zjty.switches.service;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.client.CanalConnectors;
import com.alibaba.otter.canal.common.utils.AddressUtils;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.Message;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
@Component
@Slf4j
public class CanalClientExample implements CommandLineRunner {
    @Autowired
    SwitchService switchService;
    @Value("${canal.adderss}")
    private String adderss;
    @Value("${canal.port}")
    private int port;
    @Value("${destination}")
    private String destination;
    @Value("${username}")
    private String username;
    @Value("${password}")
    private String password;
    @Value("${subscribe.regex}")
    private String regex;



    @Override
    public void run(String... args) throws Exception {
        log.info("canal开始————");
        canal();
    }

    /**
     *数据备份
     */
    public void canal() {
        // 创建链接
//        CanalConnector connector = CanalConnectors.newSingleConnector(new InetSocketAddress(AddressUtils.getHostIp(),
//                11111), "example", "", "");
        CanalConnector connector = CanalConnectors.newSingleConnector(new InetSocketAddress(adderss,
                port), destination, username, password);
        int batchSize = 1000;
        int emptyCount = 0;

        try {
            connector.connect();
//            connector.subscribe(".*\\..*");      //所有表
//            connector.subscribe("canaltest.student,canaltest2\\..*");   //canaltest下所有表
            connector.subscribe(regex);   //canaltest下所有表
            connector.rollback();
            int totalEmptyCount = 120;
            long se = 0;
            while (true) {
                Date start = new Date();
                Message message = connector.getWithoutAck(batchSize); // 获取指定数量的数据
                long batchId = message.getId();
                int size = message.getEntries().size();
                if (batchId == -1 || size == 0) {

                    emptyCount++;
//                    System.out.println("empty count : " + emptyCount);
                    try {
                        if (emptyCount > 10){
                            se = 0;
                        }
                        Thread.sleep(1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    emptyCount = 0;
                    // System.out.printf("message[batchId=%s,size=%s] \n", batchId, size);
                    printEntry(message.getEntries());

                    Date end = new Date();
                    se = se + (end.getTime() - start.getTime());
                    System.out.println("need time＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋＋:" + se);

                }

                connector.ack(batchId); // 提交确认
                // connector.rollback(batchId); // 处理失败, 回滚数据

            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            connector.disconnect();
        }
    }

    /**
     * 提取canal数据，并添加到子数据库
     * @param entrys
     */
    private void printEntry(List<CanalEntry.Entry> entrys) {
        String sql = null;
        for (CanalEntry.Entry entry : entrys) {
            if (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN || entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONEND) {
                continue;
            }

            CanalEntry.RowChange rowChage = null;
            try {
                rowChage = CanalEntry.RowChange.parseFrom(entry.getStoreValue());
            } catch (Exception e) {
                throw new RuntimeException("ERROR ## parser of eromanga-event has an error , data:" + entry.toString(),
                        e);
            }

            CanalEntry.EventType eventType = rowChage.getEventType();
            String tableName = entry.getHeader().getTableName();
            String dbName = entry.getHeader().getSchemaName();
//            System.out.println("-------------------------"+dbName);
            int  dataCount = 0;

            for (CanalEntry.RowData rowData : rowChage.getRowDatasList()) {
                if (!tableName.contains("change_ds_")){
                    tableName = "change_ds_"+tableName;
                }else {
                    tableName = "change_"+tableName.split("_")[2];
                }
                sql = getSql(eventType, tableName, rowData, dbName);
//                System.out.println(sql);
                switchService.getChangeData(sql, tableName, dbName);

            }
        }

    }



    private static void printColumn(List<CanalEntry.Column> columns) {
        for (CanalEntry.Column column : columns) {
            System.out.println(column.getName() + " : " + column.getValue() + "    update=" + column.getUpdated());
        }
    }

    /**
     * 解析canal数据，合成sql语句
     * @param eventType  操作类型
     * @param tableName  修改表名
     * @param rowData   修改数据
     * @return sql语句
     */
    private String getSql(CanalEntry.EventType eventType, String tableName, CanalEntry.RowData rowData, String dbname){
        String sql = null;
        switch (eventType) {
            case INSERT:
                sql = getInsertSql(tableName,rowData.getAfterColumnsList(), dbname);
                break;
            case UPDATE:
                sql = getUpdateSql(tableName,rowData.getAfterColumnsList(), dbname);
                break;
            case DELETE:
                sql = getDeleteSql(tableName,rowData.getBeforeColumnsList(), dbname);
                break;
            default:
                break;
        }
        return sql;
    }

    /**
     * 插入
     * @param tableName
     * @param columns
     * @return
     */
    private String getInsertSql(String tableName,List<CanalEntry.Column> columns, String dnName){
        if(columns.size() == 0 || StringUtils.isBlank(tableName)){
            return null;
        }
        String keys = "";
        String values = "";
//        System.out.println(columns);
        for(int i=0;i<columns.size();i++){
            if(i != 0) {
                keys += ",";
                values += ",";
            }
            keys += columns.get(i).getName();
//            if (columns.get(i).getMysqlType().equals("int")){
//                values += Integer.parseInt(columns.get(i).getValue());
//            }else {
//                values += getValue(columns.get(i));
//            }

            values += getValue(columns.get(i));

        }
        String format = "INSERT INTO %s (%s) VALUES (%s)";
        return String.format(format,tableName,keys,values);
//        return String.format(format,dnName + "." + tableName,keys,values);
    }

    /**
     *
     * 更新
     * @param tableName
     * @param columns
     * @return
     */
    private String getUpdateSql(String tableName,List<CanalEntry.Column> columns, String dbName){
        if(columns.size() == 0 || StringUtils.isBlank(tableName)){
            return null;
        }
        String sets = "";
        String where = "";
        for(CanalEntry.Column column : columns){
            if(column.getIsKey()){
                where = column.getName() + "=" + getValue(column);
                continue;
            }
            if(!StringUtils.isBlank(sets)) {
                sets += ",";
            }
            sets += column.getName() + "=" + getValue(column);
        }
        String format = "UPDATE %s SET %s WHERE %s";
        return String.format(format,tableName,sets,where);
    }

    /**
     * 删除
     * @param tableName
     * @param columns
     * @return
     */
    private String getDeleteSql(String tableName,List<CanalEntry.Column> columns, String dbName){
        if(columns.size() == 0 || StringUtils.isBlank(tableName)){
            return null;
        }
        String where = "";
        for(CanalEntry.Column column : columns){
            if(column.getIsKey()){
                where = column.getName() + "=" + getValue(column);
            }
        }
        String format = "DELETE FROM %s WHERE %s";
        return String.format(format,tableName,where);
    }

    private String getValue(CanalEntry.Column column){
        if(column.getIsNull()){
            return "null";
        }
        return String.format("'%s'",column.getValue());
    }


}

